package dev.felnull.otyacraftengine.client.gui.screen;

import dev.felnull.otyacraftengine.client.gui.TextureSpecifyLocation;
import dev.felnull.otyacraftengine.client.gui.components.BetterEditBox;
import dev.felnull.otyacraftengine.client.gui.components.IconButton;
import dev.felnull.otyacraftengine.client.gui.components.SwitchButton;
import dev.felnull.otyacraftengine.client.gui.components.test.TestFixedListWidget;
import dev.felnull.otyacraftengine.client.util.OETextureUtil;
import org.jetbrains.annotations.NotNull;
import var;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2585;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class TestScreen extends OEBaseScreen {
    private static final UUID id = UUID.randomUUID();
    private TestFixedListWidget testFixedListWidget;

    public TestScreen(class_437 parent) {
        super(new class_2585("Test Screen"), parent);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063(new IconButton(10, 10, 20, 20, new class_2585("TEST Icon Button"), new TextureSpecifyLocation(OETextureUtil.getPlayerSkinTexture(UUID.fromString("0f286fc2-0c86-42d5-8518-c306cad74f03")), 0, 0, 10, 10, 10, 10), n -> {

        }));

        this.method_37063(new SwitchButton(10, 40, new class_2585("TEST Switch Button"), n -> {
            System.out.println(n.isEnable());
        }, true));

        var e = this.method_37063(new BetterEditBox(10, 60, 100, 20, new class_2585("TEST Better Edit Box")));
        e.setFilter(n -> {
            try {
                Integer.parseInt(n);
                return true;
            } catch (Exception ex) {
                return false;
            }
        });

        List<String> strs = new ArrayList<>();
        for (int i = 0; i < 50; i++) {
            strs.add(UUID.randomUUID().toString());
        }

        testFixedListWidget = method_37063(new TestFixedListWidget(10, 90, 100, 100, new class_2585("TEST Fixed List"), 10, strs, (widget, item) -> System.out.println(item), true, testFixedListWidget));
        testFixedListWidget.setBorder(false);
    }

    @Override
    public void method_25394(@NotNull class_4587 poseStack, int x, int y, float f) {
        this.method_25420(poseStack);
        super.method_25394(poseStack, x, y, f);

        //  OERenderUtil.drawPlayerFace(poseStack, UUID.fromString("0f286fc2-0c86-42d5-8518-c306cad74f03"), 0, 0, height);
    }
}
