/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.libs.de.javagl.obj;

import dev.felnull.otyacraftengine.libs.de.javagl.obj.FloatTuple;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.FloatTuples;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.Obj;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.ObjFaceParser;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.ObjFaces;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.Objs;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.WritableObj;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.StringTokenizer;

public class ObjReader {
    public static Obj read(InputStream inputStream) throws IOException {
        return ObjReader.read(inputStream, Objs.create());
    }

    public static <T extends WritableObj> T read(InputStream inputStream, T output) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.US_ASCII));
        return ObjReader.readImpl(reader, output);
    }

    public static Obj read(Reader reader) throws IOException {
        return ObjReader.read(reader, Objs.create());
    }

    public static <T extends WritableObj> T read(Reader reader, T output) throws IOException {
        if (reader instanceof BufferedReader) {
            return ObjReader.readImpl((BufferedReader)reader, output);
        }
        return ObjReader.readImpl(new BufferedReader(reader), output);
    }

    private static <T extends WritableObj> T readImpl(BufferedReader reader, T output) throws IOException {
        String line;
        ObjFaceParser objFaceParser = new ObjFaceParser();
        int vertexCounter = 0;
        int texCoordCounter = 0;
        int normalCounter = 0;
        while ((line = reader.readLine()) != null) {
            String s;
            boolean finished = false;
            while (line.endsWith("\\")) {
                line = line.substring(0, line.length() - 2);
                String nextLine = reader.readLine();
                if (nextLine == null) {
                    finished = true;
                    break;
                }
                line = line + " " + nextLine;
            }
            if (finished) break;
            StringTokenizer st = new StringTokenizer(line);
            if (!st.hasMoreTokens()) continue;
            String identifier = st.nextToken().toLowerCase();
            if (identifier.equals("v")) {
                output.addVertex(ObjReader.readFloatTuple(st));
                ++vertexCounter;
                continue;
            }
            if (identifier.equals("vt")) {
                output.addTexCoord(ObjReader.readFloatTuple(st));
                ++texCoordCounter;
                continue;
            }
            if (identifier.equals("vn")) {
                output.addNormal(ObjReader.readFloatTuple(st));
                ++normalCounter;
                continue;
            }
            if (identifier.equals("mtllib")) {
                s = line.substring(6).trim();
                output.setMtlFileNames(Collections.singleton(s));
                continue;
            }
            if (identifier.equals("usemtl")) {
                String materialGroupName = line.substring(6).trim();
                output.setActiveMaterialGroupName(materialGroupName);
                continue;
            }
            if (identifier.equals("g")) {
                s = line.substring(1).trim();
                String[] groupNames = ObjReader.readStrings(s);
                output.setActiveGroupNames(Arrays.asList(groupNames));
                continue;
            }
            if (!identifier.equals("f")) continue;
            objFaceParser.parse(line);
            int[] v = objFaceParser.getVertexIndices();
            int[] vt = objFaceParser.getTexCoordIndices();
            int[] vn = objFaceParser.getNormalIndices();
            ObjReader.makeIndicesAbsolute(v, vertexCounter);
            ObjReader.makeIndicesAbsolute(vt, texCoordCounter);
            ObjReader.makeIndicesAbsolute(vn, normalCounter);
            output.addFace(ObjFaces.create(v, vt, vn));
        }
        return output;
    }

    private static void makeIndicesAbsolute(int[] array, int count) {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] < 0) {
                array[i] = count + array[i];
                continue;
            }
            int n = i;
            array[n] = array[n] - 1;
        }
    }

    private static String[] readStrings(String input) {
        StringTokenizer st = new StringTokenizer(input);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static FloatTuple readFloatTuple(StringTokenizer st) throws IOException {
        float x = ObjReader.parse(st.nextToken());
        if (st.hasMoreTokens()) {
            float y = ObjReader.parse(st.nextToken());
            if (st.hasMoreTokens()) {
                float z = ObjReader.parse(st.nextToken());
                if (st.hasMoreTokens()) {
                    float w = ObjReader.parse(st.nextToken());
                    return FloatTuples.create(x, y, z, w);
                }
                return FloatTuples.create(x, y, z);
            }
            return FloatTuples.create(x, y);
        }
        return FloatTuples.create(x);
    }

    private static float parse(String s) throws IOException {
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    private ObjReader() {
    }
}

