/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.math;

import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.math.FNVec3d;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.math.FNVec3f;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class FNVec3i {
    private int x;
    private int y;
    private int z;

    public FNVec3i() {
    }

    public FNVec3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public FNVec3i copy() {
        return new FNVec3i(this.x, this.y, this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public double distance(@NotNull FNVec3i vec) {
        return Math.sqrt(Math.pow(this.x - vec.getX(), 2.0) + Math.pow(this.y - vec.getY(), 2.0) + Math.pow(this.z - vec.getZ(), 2.0));
    }

    public FNVec3i add(@NotNull FNVec3i vec) {
        this.x += vec.getX();
        this.y += vec.getY();
        this.z += vec.getZ();
        return this;
    }

    public FNVec3i sub(@NotNull FNVec3i vec) {
        this.x -= vec.getX();
        this.y -= vec.getY();
        this.z -= vec.getZ();
        return this;
    }

    public String toString() {
        return "FNVec3i{x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FNVec3i fnVec3i = (FNVec3i)o;
        return this.x == fnVec3i.x && this.y == fnVec3i.y && this.z == fnVec3i.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public FNVec3d convertDouble() {
        return new FNVec3d(this.x, this.y, this.z);
    }

    public FNVec3f convertFloat() {
        return new FNVec3f(this.x, this.y, this.z);
    }
}

