package dev.felnull.otyacraftengine.client.renderer;

import dev.felnull.otyacraftengine.mixin.client.ScreenAccessor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import var;

public class GuiDebugRenderer {

    public static void onScreenRender(class_437 screen, class_4587 posestack, int mouseX, int mouseY, float delta) {
        screen.method_30901(posestack, createDebugTexts(screen, mouseX, mouseY), mouseX, mouseY);
    }

    private static List<class_2561> createDebugTexts(class_437 screen, int x, int y) {
        List<class_2561> txs = new ArrayList<>();
        ScreenAccessor sa = (ScreenAccessor) screen;
        var rs = sa.getRenderables().stream().filter(n -> n instanceof class_339).map(n -> (class_339) n).filter(n -> x >= n.field_22760 && y >= n.field_22761 && x < (n.field_22760 + n.method_25368()) && y < (double) (n.field_22761 + n.method_25364())).toList();
        if (rs.isEmpty()) return txs;
        if (rs.size() == 1) {
            appendWidgetDebugText(txs, rs.get(0));
        } else {
            txs.add(new class_2585("-------------"));
            for (class_339 renderable : rs) {
                appendWidgetDebugText(txs, renderable);
                txs.add(new class_2585("-------------"));
            }
        }
        return txs;
    }

    private static void appendWidgetDebugText(List<class_2561> txs, class_339 widget) {
        txs.add(new class_2585("Message: ").method_10852(widget.method_25369()));
        txs.add(new class_2585("Class: ").method_27693(widget.getClass().toString()));
    }
}
