/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.fabric.client.model;

import com.mojang.datafixers.util.Pair;
import dev.felnull.otyacraftengine.fabric.client.model.OBJModel;
import dev.felnull.otyacraftengine.fabric.client.model.OBJMtlData;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.FloatTuple;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.Mtl;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.Obj;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.ObjSplitting;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.ObjUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1160;
import net.minecraft.class_1723;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OBJUnbakedModelModel
implements class_1100 {
    public static final class_4730 DEFAULT_SPRITE = new class_4730(class_1723.field_21668, null);
    private final Obj modelObj;
    private final Map<String, OBJMtlData> mtls;
    private final class_809 transforms;
    private final class_4730 material;

    public OBJUnbakedModelModel(Obj modelObj, Map<String, OBJMtlData> mtls, class_809 transforms) {
        this.modelObj = ObjUtils.triangulate(modelObj);
        this.mtls = mtls;
        this.transforms = transforms;
        Mtl mtl = mtls.get("sprite");
        this.material = mtls.size() > 0 ? new class_4730(class_1723.field_21668, new class_2960((mtl == null ? (Mtl)mtls.values().iterator().next() : mtl).getMapKd())) : DEFAULT_SPRITE;
    }

    public Collection<class_2960> method_4755() {
        return Collections.emptySet();
    }

    public Collection<class_4730> method_4754(Function<class_2960, class_1100> function, Set<Pair<String, String>> set) {
        ArrayList<class_4730> sprites = new ArrayList<class_4730>();
        this.mtls.values().forEach(mtl -> sprites.add(new class_4730(class_1723.field_21668, new class_2960(mtl.getMapKd()))));
        return sprites;
    }

    @Nullable
    public class_1087 method_4753(@NotNull class_1088 modelBakery, @NotNull Function<class_4730, class_1058> function, @NotNull class_3665 modelState, @NotNull class_2960 resourceLocation) {
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        if (renderer == null) {
            renderer = IndigoRenderer.INSTANCE;
        }
        Map<String, Obj> materialGroups = ObjSplitting.splitByMaterialGroups(this.modelObj);
        MeshBuilder builder = renderer.meshBuilder();
        QuadEmitter emitter = builder.getEmitter();
        for (Map.Entry<String, Obj> entry : materialGroups.entrySet()) {
            String matName = entry.getKey();
            Obj matGroupObj = entry.getValue();
            OBJMtlData mtl = this.mtls.get(matName);
            int color = -1;
            class_1058 mtlSprite = function.apply(DEFAULT_SPRITE);
            if (mtl != null) {
                FloatTuple diffuseColor = mtl.getKd();
                if (mtl.useDiffuseColor()) {
                    color = -16777216;
                    for (int i = 0; i < 3; ++i) {
                        color |= (int)(255.0f * diffuseColor.get(i)) << 16 - 8 * i;
                    }
                }
                mtlSprite = function.apply(new class_4730(class_1723.field_21668, new class_2960(mtl.getMapKd())));
            }
            for (int i = 0; i < matGroupObj.getNumFaces(); ++i) {
                for (int v = 0; v < matGroupObj.getFace(i).getNumVertices(); ++v) {
                    FloatTuple floatTuple = matGroupObj.getVertex(matGroupObj.getFace(i).getVertexIndex(v));
                    class_1160 vertex = new class_1160(floatTuple.getX(), floatTuple.getY(), floatTuple.getZ());
                    FloatTuple normal = matGroupObj.getNormal(matGroupObj.getFace(i).getNormalIndex(v));
                    this.addVertex(i, v, vertex, normal, emitter, matGroupObj, false, modelState);
                    if (v != 2 || matGroupObj.getFace(i).getNumVertices() != 3) continue;
                    this.addVertex(i, 3, vertex, normal, emitter, matGroupObj, true, modelState);
                }
                emitter.spriteColor(0, color, color, color, color);
                emitter.material(renderer.materialFinder().find());
                emitter.colorIndex(mtl.getTintIndex());
                emitter.nominalFace(emitter.lightFace());
                emitter.spriteBake(0, mtlSprite, 0x20 | (modelState.method_3512() ? 4 : 0));
                emitter.emit();
            }
        }
        Mesh mesh = builder.build();
        return new OBJModel(mesh, this.transforms, function.apply(this.material));
    }

    private void addVertex(int faceIndex, int vertIndex, class_1160 vertex, FloatTuple normal, QuadEmitter emitter, Obj matGroup, boolean degenerate, class_3665 modelState) {
        try {
            int textureCoordIndex = vertIndex;
            if (degenerate) {
                --textureCoordIndex;
            }
            if (modelState.method_3509() != class_4590.method_22931() && !degenerate) {
                vertex.method_4948(-0.5f, -0.5f, -0.5f);
                vertex.method_19262(modelState.method_3509().method_22937());
                vertex.method_4948(0.5f, 0.5f, 0.5f);
            }
            emitter.pos(vertIndex, vertex.method_4943(), vertex.method_4945(), vertex.method_4947());
            emitter.normal(vertIndex, normal.getX(), normal.getY(), normal.getZ());
            if (this.modelObj.getNumTexCoords() > 0) {
                FloatTuple text = matGroup.getTexCoord(matGroup.getFace(faceIndex).getTexCoordIndex(textureCoordIndex));
                emitter.sprite(vertIndex, 0, text.getX(), text.getY());
            } else {
                emitter.nominalFace(class_2350.method_10147((float)normal.getX(), (float)normal.getY(), (float)normal.getZ()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

