/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.fabric.client.model;

import dev.felnull.otyacraftengine.fabric.client.model.OBJMtlData;
import dev.felnull.otyacraftengine.include.de.javagl.obj.Mtls;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class OBJMtlReader {
    public static List<OBJMtlData> read(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        return OBJMtlReader.readImpl(reader);
    }

    public static List<OBJMtlData> read(Reader reader) throws IOException {
        if (reader instanceof BufferedReader) {
            return OBJMtlReader.readImpl((BufferedReader)reader);
        }
        return OBJMtlReader.readImpl(new BufferedReader(reader));
    }

    private static List<OBJMtlData> readImpl(BufferedReader reader) throws IOException {
        Object line;
        ArrayList<OBJMtlData> mtlList = new ArrayList<OBJMtlData>();
        OBJMtlData currentMtl = null;
        while ((line = reader.readLine()) != null) {
            line = ((String)line).trim();
            boolean finished = false;
            while (((String)line).endsWith("\\")) {
                line = ((String)line).substring(0, ((String)line).length() - 2);
                String nextLine = reader.readLine();
                if (nextLine == null) {
                    finished = true;
                    break;
                }
                line = (String)line + " " + nextLine;
            }
            if (finished) break;
            StringTokenizer st = new StringTokenizer((String)line);
            if (!st.hasMoreTokens()) continue;
            String identifier = st.nextToken();
            if (identifier.equalsIgnoreCase("newmtl")) {
                String name = ((String)line).substring("newmtl".length()).trim();
                currentMtl = new OBJMtlData(Mtls.create(name));
                mtlList.add(currentMtl);
                continue;
            }
            if (identifier.equalsIgnoreCase("Ka")) {
                float ka0 = OBJMtlReader.parseFloat(st.nextToken());
                float ka1 = OBJMtlReader.parseFloat(st.nextToken());
                float ka2 = OBJMtlReader.parseFloat(st.nextToken());
                currentMtl.setKa(ka0, ka1, ka2);
                continue;
            }
            if (identifier.equalsIgnoreCase("Ks")) {
                float ks0 = OBJMtlReader.parseFloat(st.nextToken());
                float ks1 = OBJMtlReader.parseFloat(st.nextToken());
                float ks2 = OBJMtlReader.parseFloat(st.nextToken());
                currentMtl.setKs(ks0, ks1, ks2);
                continue;
            }
            if (identifier.equalsIgnoreCase("Kd")) {
                float kd0 = OBJMtlReader.parseFloat(st.nextToken());
                float kd1 = OBJMtlReader.parseFloat(st.nextToken());
                float kd2 = OBJMtlReader.parseFloat(st.nextToken());
                currentMtl.setKd(kd0, kd1, kd2);
                continue;
            }
            if (identifier.equalsIgnoreCase("map_Kd")) {
                String mapKd = ((String)line).substring("map_Kd".length()).trim();
                currentMtl.setMapKd(mapKd);
                continue;
            }
            if (identifier.equalsIgnoreCase("d")) {
                float d = OBJMtlReader.parseFloat(st.nextToken());
                currentMtl.setD(d);
                continue;
            }
            if (identifier.equalsIgnoreCase("Ns")) {
                float ns = OBJMtlReader.parseFloat(st.nextToken());
                currentMtl.setNs(ns);
                continue;
            }
            if (identifier.equalsIgnoreCase("tintindex")) {
                int tint = OBJMtlReader.parseInt(st.nextToken());
                currentMtl.setTintIndex(tint);
                continue;
            }
            if (!identifier.equalsIgnoreCase("use_diffuse")) continue;
            currentMtl.setUseDiffuseColor();
        }
        return mtlList;
    }

    private static float parseFloat(String s) throws IOException {
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    private static int parseInt(String s) throws IOException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }
}

