/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util;

import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNURLUtil;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class DiscordWebHookBuilder {
    private final String url;
    private final String content;
    private String userName;
    private String avatarUrl;

    public DiscordWebHookBuilder(String url, String content) {
        this.url = url;
        this.content = content;
    }

    public DiscordWebHookBuilder setUsername(String userName) {
        this.userName = userName;
        return this;
    }

    public DiscordWebHookBuilder setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    }

    public String createContent() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.userName != null) {
            sb.append(String.format("\"username\": \"%s\",", this.userName));
        }
        if (this.avatarUrl != null) {
            sb.append(String.format("\"avatar_url\": \"%s\",", this.avatarUrl));
        }
        sb.append(String.format("\"content\": \"%s\"", this.content));
        sb.append("}");
        return sb.toString();
    }

    public int send() throws IOException {
        return FNURLUtil.getResponseByPOST(new URL(this.url), this.createContent(), "jp", "application/JSON").getEntry();
    }

    public CompletableFuture<Void> sendAsync(Consumer<Integer> response) throws IOException {
        return FNURLUtil.getResponseByPOSTAsync(new URL(this.url), this.createContent(), "jp", "application/JSON", n -> {
            if (response != null) {
                response.accept((Integer)n.getRight());
            }
        });
    }
}

