/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.motion;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.client.motion.MotionPoint;
import dev.felnull.otyacraftengine.client.motion.MotionPose;
import dev.felnull.otyacraftengine.client.motion.MotionRotation;
import dev.felnull.otyacraftengine.client.motion.MotionSwapper;
import dev.felnull.otyacraftengine.util.OEMath;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1160;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

public class Motion {
    public static final Motion EMPTY = new Motion(List.of());
    private final List<MotionPoint> points;
    private final float[] elapsedRatio;

    public Motion(@NotNull List<MotionPoint> points) {
        if (!(points instanceof ImmutableCollection)) {
            points = ImmutableList.copyOf(points);
        }
        this.points = points;
        this.elapsedRatio = new float[this.points.size()];
        if (this.elapsedRatio.length == 0) {
            return;
        }
        this.elapsedRatio[0] = 0.0f;
        if (this.elapsedRatio.length == 1) {
            return;
        }
        for (int i = 1; i < this.elapsedRatio.length; ++i) {
            this.elapsedRatio[i] = this.elapsedRatio[i - 1] + this.points.get(i - 1).getRatio();
        }
    }

    public static Motion of(Motion ... motions) {
        return new Motion(Arrays.stream(motions).flatMap(n -> n.getPoints().stream()).toList());
    }

    public static Motion of(MotionPoint ... points) {
        return new Motion(Arrays.stream(points).toList());
    }

    public static Motion of(JsonObject json) {
        int v = json.get("version").getAsInt();
        if (v != 1) {
            throw new IllegalStateException("Unsupported motion version");
        }
        JsonArray ja = json.getAsJsonArray("points");
        ImmutableList.Builder builder = ImmutableList.builder();
        ja.forEach(n -> builder.add((Object)MotionPoint.of(n.getAsJsonObject())));
        return new Motion((List<MotionPoint>)builder.build());
    }

    public JsonObject toJson() {
        JsonObject jo = new JsonObject();
        jo.addProperty("version", (Number)1);
        JsonArray ja = new JsonArray();
        this.points.forEach(n -> ja.add((JsonElement)n.toJson()));
        jo.add("points", (JsonElement)ja);
        return jo;
    }

    public float getTotalRatio() {
        return this.elapsedRatio[this.elapsedRatio.length - 1];
    }

    public List<MotionPoint> getPoints() {
        return this.points;
    }

    @NotNull
    public Triple<MotionPoint, MotionPoint, Integer> getPontByRatio(float ratio) {
        if (this.points.size() == 1) {
            return Triple.of((Object)this.points.get(0), (Object)this.points.get(0), (Object)0);
        }
        ratio = class_3532.method_15363((float)ratio, (float)0.0f, (float)this.getTotalRatio());
        int num = 0;
        for (int i = 0; i < this.elapsedRatio.length - 1; ++i) {
            float ls = this.elapsedRatio[i];
            float le = this.elapsedRatio[i + 1];
            if (!(ls <= ratio) || !(le >= ratio)) continue;
            num = i;
            break;
        }
        return Triple.of((Object)this.points.get(num), (Object)this.points.get(num + 1), (Object)num);
    }

    public MotionPose getPose(float par) {
        return this.getPose(par, MotionSwapper.EMPTY);
    }

    public MotionPose getPose(float par, MotionSwapper swapper) {
        return this.getPose(par, swapper, 0, Math.max(this.points.size() - 1, 0));
    }

    public MotionPose getPose(float par, MotionSwapper swapper, int start, int end) {
        MotionRotation rot;
        class_1160 pos;
        if (this.points.isEmpty()) {
            return new MotionPose(class_1160.field_29501, new MotionRotation());
        }
        float rp = this.elapsedRatio[start] + (this.elapsedRatio[end] - this.elapsedRatio[start]) * par;
        Triple<MotionPoint, MotionPoint, Integer> iv = this.getPontByRatio(rp);
        MotionPoint st = (MotionPoint)iv.getLeft();
        MotionPoint en = (MotionPoint)iv.getMiddle();
        MotionPoint ps = swapper.swapPrePoint(this, par, (Integer)iv.getRight(), st, en);
        if (ps != null) {
            st = ps;
        }
        if (this.points.size() == 1) {
            return st.getPose();
        }
        MotionPoint ns = swapper.swapNextPoint(this, par, (Integer)iv.getRight(), st, en);
        if (ns != null) {
            en = ns;
        }
        if (st == en) {
            pos = st.getPosition();
            rot = st.getRotation();
        } else {
            float rrp = st.getRatio() / this.getTotalRatio();
            float rep = this.elapsedRatio[(Integer)iv.getRight()] / this.getTotalRatio();
            float op = (par - rep) / rrp;
            pos = OEMath.leap(op, st.getPosition(), en.getPosition());
            rot = OEMath.leap(op, st.getRotation(), en.getRotation());
        }
        return new MotionPose(pos, rot);
    }

    public void pose(float par, Consumer<MotionPose> pose, MotionSwapper swapper) {
        pose.accept(this.getPose(par, swapper));
    }

    public void pose(float par, Consumer<MotionPose> pose) {
        this.pose(par, pose, MotionSwapper.EMPTY);
    }

    public void pose(@NotNull class_4587 stack, float par, MotionSwapper swapper) {
        MotionPose pose = this.getPose(par, swapper);
        pose.pose(stack);
    }

    public void pose(@NotNull class_4587 stack, float par) {
        this.pose(stack, par, MotionSwapper.EMPTY);
    }

    public String toString() {
        return "Motion{points=" + this.points + ", elapsedRatio=" + Arrays.toString(this.elapsedRatio) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Motion motion = (Motion)o;
        return Objects.equals(this.points, motion.points) && Arrays.equals(this.elapsedRatio, motion.elapsedRatio);
    }

    public int hashCode() {
        int result = Objects.hash(this.points);
        result = 31 * result + Arrays.hashCode(this.elapsedRatio);
        return result;
    }
}

