package dev.felnull.otyacraftengine.client.motion;

import MotionPose;
import MotionRotation;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.class_1160;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import var;

public class MotionPoint {
    private final class_1160 position;
    private final MotionRotation rotation;
    //このポイントから次のポイントまでの間の比率
    private final float ratio;

    public MotionPoint(float px, float py, float pz, float ax, float ay, float az, float ox, float oy, float oz, boolean rx, boolean ry, boolean rz) {
        this(new class_1160(px, py, pz), new MotionRotation(ax, ay, az, ox, oy, oz, rx, ry, rz));
    }

    public MotionPoint(MotionPose pose, float ratio) {
        this(pose.position(), pose.rotation(), ratio);
    }

    public MotionPoint(class_1160 position, MotionRotation rotation) {
        this(position, rotation, 1f);
    }

    public MotionPoint(class_1160 position, MotionRotation rotation, float ratio) {
        this.position = position;
        this.rotation = rotation;
        this.ratio = ratio;
    }

    public static MotionPoint of(JsonObject jo) {
        var pos = jo.getAsJsonArray("pos");
        var jr = jo.get("rat");
        float rat = 1f;
        if (jr != null)
            rat = jr.getAsFloat();
        return new MotionPoint(new class_1160(pos.get(0).getAsFloat(), pos.get(1).getAsFloat(), pos.get(2).getAsFloat()), MotionRotation.of(jo.getAsJsonObject("rot")), rat);
    }

    public JsonObject toJson() {
        var jo = new JsonObject();
        var p = new JsonArray();
        p.add(position.method_4943());
        p.add(position.method_4945());
        p.add(position.method_4947());
        jo.add("pos", p);
        jo.add("rot", rotation.toJson());
        if (ratio != 1f)
            jo.addProperty("rat", ratio);
        return jo;
    }

    public MotionRotation getRotation() {
        return rotation;
    }

    public class_1160 getPosition() {
        return position;
    }

    public float getRatio() {
        return ratio;
    }

    public class_2561 getText() {
        return new class_2585(String.format("%s [%s,%s,%s] [%s,%s,%s]", ratio, position.method_4943(), position.method_4945(), position.method_4947(), rotation.angle().x(), rotation.angle().y(), rotation.angle().z()));
    }

    public MotionPose getPose() {
        return new MotionPose(new class_1160(position.method_4943(), position.method_4945(), position.method_4947()), rotation);
    }

    @Override
    public String toString() {
        return "MotionPoint{" +
                "position=" + position +
                ", rotation=" + rotation +
                ", ratio=" + ratio +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MotionPoint that = (MotionPoint) o;
        return Float.compare(that.ratio, ratio) == 0 && Objects.equals(position, that.position) && Objects.equals(rotation, that.rotation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(position, rotation, ratio);
    }
}