/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.include.dev.felnull.fnjl.io;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class FolderWatcher {
    private final Path rootPath;
    private final FolderWatchListener folderWatchListener;
    private final List<SubFolderWatcher> watchers = new ArrayList<SubFolderWatcher>();

    public FolderWatcher(Path rootPath, FolderWatchListener folderWatchListener) throws IOException {
        this.rootPath = rootPath.toAbsolutePath();
        this.folderWatchListener = folderWatchListener;
        Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (dir.toFile().exists() && dir.toFile().isDirectory()) {
                    try {
                        SubFolderWatcher subFolderWatcher = new SubFolderWatcher(dir, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE});
                        FolderWatcher.this.watchers.add(subFolderWatcher);
                        subFolderWatcher.start();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(SubFolderWatcher watcher, Path path, String name, WatchEvent<?> watchEvent) {
        Path target = path.resolve(name);
        List<SubFolderWatcher> list = this.watchers;
        synchronized (list) {
            this.folderWatchListener.update(target, watchEvent);
            boolean wacherFlg = this.watchers.stream().anyMatch(w -> ((SubFolderWatcher)w).path.equals(target));
            if (watchEvent.kind() == StandardWatchEventKinds.ENTRY_DELETE && wacherFlg) {
                ArrayList rmWatchers = new ArrayList();
                this.watchers.stream().filter(w -> ((SubFolderWatcher)w).path.equals(target)).forEach(rmWatchers::add);
                rmWatchers.forEach(n -> {
                    n.interrupt();
                    this.watchers.remove(n);
                });
            }
            if (!wacherFlg && watchEvent.kind() == StandardWatchEventKinds.ENTRY_CREATE && target.toFile().isDirectory()) {
                try {
                    SubFolderWatcher subFolderWatcher = new SubFolderWatcher(target, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE});
                    this.watchers.add(subFolderWatcher);
                    subFolderWatcher.start();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public int getWatcherCont() {
        return this.watchers.size();
    }

    public static interface FolderWatchListener {
        public void update(Path var1, WatchEvent<?> var2);
    }

    private class SubFolderWatcher
    extends Thread {
        private final Path path;
        private final WatchService watchService;

        private SubFolderWatcher(Path path, WatchEvent.Kind<?> ... events) throws IOException {
            this.path = path.toAbsolutePath();
            this.watchService = FileSystems.getDefault().newWatchService();
            this.path.register(this.watchService, events);
            this.setName(path + " watcher");
        }

        @Override
        public void run() {
            while (this.isAlive()) {
                WatchKey take;
                try {
                    take = this.watchService.take();
                }
                catch (InterruptedException e) {
                    return;
                }
                for (WatchEvent<?> pollEvent : take.pollEvents()) {
                    FolderWatcher.this.update(this, this.path, pollEvent.context().toString(), pollEvent);
                }
                take.reset();
            }
        }
    }
}

