/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.debug.socket;

import dev.felnull.otyacraftengine.client.debug.socket.SocketDebugService;
import dev.felnull.otyacraftengine.client.debug.socket.TextSocketObject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugConnection {
    private static final Logger LOGGER = LogManager.getLogger(DebugConnection.class);
    private final String adress;
    private final int port;
    private final Object lock = new Object();
    private ServerSocket serverSocket;
    private Socket socket;
    private InputThread inputThread;
    private ObjectOutputStream outputStream;

    public DebugConnection(String adress, int port) {
        this.adress = adress;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        LOGGER.info("Socket connection started");
        this.serverSocket = new ServerSocket(this.port);
        LOGGER.info("Wait for client connection");
        this.socket = this.serverSocket.accept();
        this.inputThread = new InputThread();
        this.inputThread.start();
        this.outputStream = new ObjectOutputStream(this.socket.getOutputStream());
        LOGGER.info("Completed to connect with client");
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait();
        }
        LOGGER.info("The connection with the client has ended");
        this.close();
        LOGGER.info("Stopped communication with the socket");
    }

    public boolean isOpen() {
        return this.socket != null && !this.socket.isClosed();
    }

    public void sendText(String text) {
        this.send(new TextSocketObject(text));
    }

    public synchronized void send(Object object) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeObject(object);
            this.outputStream.flush();
        }
        catch (IOException e) {
            LOGGER.error("Failed to send", (Throwable)e);
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public void close() throws IOException {
        this.serverSocket.close();
        this.socket.shutdownInput();
        this.socket.shutdownOutput();
        this.socket.close();
    }

    private class InputThread
    extends Thread {
        private InputThread() {
        }

        @Override
        public void run() {
            boolean loop;
            ObjectInputStream stream;
            try {
                stream = new ObjectInputStream(DebugConnection.this.socket.getInputStream());
            }
            catch (Exception e) {
                LOGGER.error("Failed to start reception", (Throwable)e);
                DebugConnection.this.stop();
                return;
            }
            do {
                loop = true;
                try {
                    Object obj = stream.readObject();
                    if (!(obj instanceof TextSocketObject)) continue;
                    TextSocketObject textSocketObject = (TextSocketObject)obj;
                    SocketDebugService.onText(textSocketObject.getDataText());
                }
                catch (IOException e) {
                    LOGGER.error("Receive failed", (Throwable)e);
                    loop = false;
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Receive failed", (Throwable)e);
                }
            } while (loop);
            DebugConnection.this.stop();
        }
    }
}

