/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.motion;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.client.motion.MotionPose;
import dev.felnull.otyacraftengine.client.motion.MotionRotation;
import java.util.Objects;
import net.minecraft.class_1160;
import net.minecraft.class_2561;
import net.minecraft.class_2585;

public class MotionPoint {
    private final class_1160 position;
    private final MotionRotation rotation;
    private final float ratio;

    public MotionPoint(float px, float py, float pz, float ax, float ay, float az, float ox, float oy, float oz, boolean rx, boolean ry, boolean rz) {
        this(new class_1160(px, py, pz), new MotionRotation(ax, ay, az, ox, oy, oz, rx, ry, rz));
    }

    public MotionPoint(MotionPose pose, float ratio) {
        this(pose.position(), pose.rotation(), ratio);
    }

    public MotionPoint(class_1160 position, MotionRotation rotation) {
        this(position, rotation, 1.0f);
    }

    public MotionPoint(class_1160 position, MotionRotation rotation, float ratio) {
        this.position = position;
        this.rotation = rotation;
        this.ratio = ratio;
    }

    public static MotionPoint of(JsonObject jo) {
        JsonArray pos = jo.getAsJsonArray("pos");
        JsonElement jr = jo.get("rat");
        float rat = 1.0f;
        if (jr != null) {
            rat = jr.getAsFloat();
        }
        return new MotionPoint(new class_1160(pos.get(0).getAsFloat(), pos.get(1).getAsFloat(), pos.get(2).getAsFloat()), MotionRotation.of(jo.getAsJsonObject("rot")), rat);
    }

    public JsonObject toJson() {
        JsonObject jo = new JsonObject();
        JsonArray p = new JsonArray();
        p.add((Number)Float.valueOf(this.position.method_4943()));
        p.add((Number)Float.valueOf(this.position.method_4945()));
        p.add((Number)Float.valueOf(this.position.method_4947()));
        jo.add("pos", (JsonElement)p);
        jo.add("rot", (JsonElement)this.rotation.toJson());
        if (this.ratio != 1.0f) {
            jo.addProperty("rat", (Number)Float.valueOf(this.ratio));
        }
        return jo;
    }

    public MotionRotation getRotation() {
        return this.rotation;
    }

    public class_1160 getPosition() {
        return this.position;
    }

    public float getRatio() {
        return this.ratio;
    }

    public class_2561 getText() {
        return new class_2585(String.format("%s [%s,%s,%s] [%s,%s,%s]", Float.valueOf(this.ratio), Float.valueOf(this.position.method_4943()), Float.valueOf(this.position.method_4945()), Float.valueOf(this.position.method_4947()), Float.valueOf(this.rotation.angle().method_4943()), Float.valueOf(this.rotation.angle().method_4945()), Float.valueOf(this.rotation.angle().method_4947())));
    }

    public MotionPose getPose() {
        return new MotionPose(new class_1160(this.position.method_4943(), this.position.method_4945(), this.position.method_4947()), this.rotation);
    }

    public String toString() {
        return "MotionPoint{position=" + this.position + ", rotation=" + this.rotation + ", ratio=" + this.ratio + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MotionPoint that = (MotionPoint)o;
        return Float.compare(that.ratio, this.ratio) == 0 && Objects.equals(this.position, that.position) && Objects.equals(this.rotation, that.rotation);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.rotation, Float.valueOf(this.ratio));
    }
}

