package dev.felnull.otyacraftengine.client.motion;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;

public class MotionManager extends class_4080<MotionLoader> {
    private static MotionManager INSTANCE;
    private Map<class_2960, Motion> motions;

    public MotionManager() {
        INSTANCE = this;
    }

    public static MotionManager getInstance() {
        return INSTANCE;
    }

    @Override
    protected MotionLoader method_18789(@NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        return new MotionLoader(resourceManager, profilerFiller);
    }

    @Override
    protected void apply(@NotNull MotionLoader loader, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        motions = loader.getMotions();
    }

    @Nullable
    public Map<class_2960, Motion> getMotions() {
        return motions;
    }

    @NotNull
    public Motion getMotion(class_2960 location) {
        if (motions == null) return Motion.EMPTY;
        return motions.get(location);
    }
}
