package dev.felnull.otyacraftengine.client.handler;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.felnull.otyacraftengine.client.debug.MotionDebug;
import dev.felnull.otyacraftengine.client.debug.socket.SocketDebugService;
import dev.felnull.otyacraftengine.client.event.ClientEvent;
import dev.felnull.otyacraftengine.client.event.MoreRenderEvent;
import dev.felnull.otyacraftengine.client.gui.components.FixedButtonsList;
import dev.felnull.otyacraftengine.client.gui.screen.DebugScreen;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import dev.felnull.otyacraftengine.impl.client.OEClientExpectPlatform;
import org.lwjgl.glfw.GLFW;
import record;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1777;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_746;
import net.minecraft.class_809;
import net.minecraft.class_989;

public class TestClientHandler {
    public static final class_304 TEST_KEY = new class_304("key.otyacraftengine.test", GLFW.GLFW_KEY_J, "key.categories.otyacraftengine");
    private static final class_310 mc = class_310.method_1551();

    public static void init() {
        KeyMappingRegistry.register(TEST_KEY);

        ClientRawInputEvent.KEY_PRESSED.register(TestClientHandler::onKeyPressed);
        MoreRenderEvent.RENDER_ITEM_IN_HAND.register(TestClientHandler::onRenderHand);
        ClientEvent.CHANGE_HAND_HEIGHT.register(TestClientHandler::changeHandHeight);
        ClientEvent.POSE_HUMANOID_ARM.register(TestClientHandler::poseHumanoidArm);
        ClientEvent.POSE_HUMANOID_ARM_POST.register(TestClientHandler::poseHumanoidArmPost);
        MoreRenderEvent.RENDER_ARM_WITH_ITEM.register(TestClientHandler::renderArmWithItem);
        ClientEvent.INTEGRATED_SERVER_PAUSE.register(TestClientHandler::onIntegratedPauseChange);
        ClientTickEvent.CLIENT_POST.register(TestClientHandler::ontClientTick);
        ClientEvent.HAND_ATTACK.register(TestClientHandler::onHandAttack);
        ClientEvent.EVALUATE_RENDER_HANDS.register(TestClientHandler::onEvaluateRenderHands);
    }

    private static void onEvaluateRenderHands(ClientEvent.HandRenderSelectionWrapper handRenderSelection, class_746 player, ClientEvent.EvaluateRenderHandSetter setter) {
        if (player.method_6047().method_31574(class_1802.field_8449))
            setter.setEvaluate(ClientEvent.HandRenderSelectionWrapper.onlyForHand(class_1268.field_5808));
    }

    private static EventResult onHandAttack(class_1799 itemStack) {
        //    if (itemStack.is(Items.DIAMOND))
        //        return EventResult.interruptFalse();
        return EventResult.pass();
    }

    private static void ontClientTick(class_310 instance) {
        SocketDebugService.tick();
    }

    public static void onIntegratedPauseChange(boolean paused) {
        // System.out.println(paused);
    }

    public static EventResult onKeyPressed(class_310 client, int keyCode, int scanCode, int action, int modifiers) {
        //   System.out.println(OEClientUtil.isKeyInput(OEClientExpectPlatform.getKey(TEST_KEY).getValue()));
        if (keyCode == OEClientExpectPlatform.getKey(TEST_KEY).method_1444()) {
            client.method_1507(new DebugScreen());
        }
        return EventResult.interruptDefault();
    }

    public static EventResult onRenderHand(class_4587 poseStack, class_4597 multiBufferSource, class_1268 hand, int packedLight, float partialTicks, float interpolatedPitch, float swingProgress, float equipProgress, class_1799 stack) {
        if (stack.method_7909() instanceof class_1777) {
            boolean bl = hand == class_1268.field_5808;
            class_1306 arm = bl ? mc.field_1724.method_6068() : mc.field_1724.method_6068().method_5928();
            poseStack.method_22903();
            MotionDebug.getInstance().onDebug(poseStack, multiBufferSource, .5f);
            poseStack.method_22903();
            OERenderUtil.posePlayerArm(poseStack, arm, swingProgress, equipProgress);
            OERenderUtil.renderPlayerArm(poseStack, multiBufferSource, arm, packedLight);
            poseStack.method_22909();
            poseStack.method_22903();
            OERenderUtil.poseHandItem(poseStack, arm, swingProgress, equipProgress);
            OERenderUtil.renderHandItem(poseStack, multiBufferSource, arm, stack, packedLight);
            poseStack.method_22909();
            poseStack.method_22909();
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static EventResult changeHandHeight(class_1268 hand, class_1799 oldStack, class_1799 newStack) {
       /* if (oldStack.getItem() == newStack.getItem()) {
            if (oldStack.getDisplayName().getString().equals(newStack.getDisplayName().getString())) {
                return EventResult.interruptFalse();
            }
        }*/

        //  if (hand == InteractionHand.MAIN_HAND)
        //      System.out.println(oldStack.hashCode() +" : "+ newStack.hashCode());
        return EventResult.pass();
    }

    public static EventResult poseHumanoidArm(class_1306 arm, class_1268 hand, class_572<? extends class_1309> model, class_1309 livingEntity) {
       /* if (hand == InteractionHand.MAIN_HAND && livingEntity.getMainHandItem().is(Items.BOW)) {
            model.rightArm.xRot = (float) (-OERenderUtil.getParSecond(1000) * Math.PI);
            model.leftArm.xRot = (float) (-(1f - OERenderUtil.getParSecond(1000)) * Math.PI);
            return EventResult.interruptFalse();
        }*/
        return EventResult.pass();
    }

    public static void poseHumanoidArmPost(class_1306 arm, class_1268 hand, class_572<? extends class_1309> model, class_1309 livingEntity) {
       // model.rightArm.xRot = model.rightArm.xRot + Mth.PI * OERenderUtil.getParSecond(1000);
    }

    public static EventResult renderArmWithItem(class_989<? extends class_1309, ? extends class_583<?>> layer, class_1309 livingEntity, class_1799 itemStack, class_809.class_811 transformType, class_1306 humanoidArm, class_4587 poseStack, class_4597 multiBufferSource, int i) {
        /*if (itemStack.is(Items.APPLE)) {
            poseStack.pushPose();
            ModelPart modelPart = ((HeadedModel) layer.getParentModel()).getHead();
            float f = modelPart.xRot;
            modelPart.xRot = Mth.clamp(modelPart.xRot, -0.5235988F, 1.5707964F);
            modelPart.translateAndRotate(poseStack);
            modelPart.xRot = f;
            CustomHeadLayer.translateToHead(poseStack, false);
            boolean bl = humanoidArm == HumanoidArm.LEFT;
            poseStack.translate((bl ? -2.5F : 2.5F) / 16.0F, -0.0625D, 0.0D);
            Minecraft.getInstance().getItemInHandRenderer().renderItem(livingEntity, itemStack, ItemTransforms.TransformType.HEAD, false, poseStack, multiBufferSource, i);
            poseStack.popPose();
            return EventResult.interruptFalse();
        }*/
        return EventResult.pass();
    }

    private static class PointFixedButtonsList extends FixedButtonsList<MotionPoint> {

        public PointFixedButtonsList(int x, int y, int w, int h, class_2960 resource, int tx, int ty, int tw, int th, int num, class_2561 name, List<MotionPoint> list, Function<MotionPoint, class_2561> listName, PressEntry<MotionPoint> onPressEntry) {
            super(x, y, w, h, resource, tx, ty, tw, th, num, name, list, listName, onPressEntry);
        }
    }

    private static record MotionPoint(class_1160 position, class_1160 rotation, class_1160 scale) {

    }
}
