/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util;

import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.FelNullJavaLibrary;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.tuple.FNPair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class FNURLUtil {
    public static String getUserAgent() {
        String jv = System.getProperty("java.version");
        String jvn = System.getProperty("java.vm.name");
        String jvv = System.getProperty("java.vm.version");
        return String.format("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/94.0.4606.61 Safari/537.36 %s %s", "Java/" + jv + " (" + jvn + "; " + jvv + ")", "FelNullJavaLibrary/" + FelNullJavaLibrary.getVersion());
    }

    public static HttpURLConnection getConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("user-agent", FNURLUtil.getUserAgent());
        return connection;
    }

    public static InputStream getStream(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("user-agent", FNURLUtil.getUserAgent());
        return connection.getInputStream();
    }

    public static String getResponse(URL url) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(FNURLUtil.getStream(url), StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            sb.append(inputLine).append('\n');
        }
        in.close();
        return sb.toString();
    }

    public static CompletableFuture<Void> getStreamAsync(URL url, Consumer<InputStream> streamConsumer) {
        return CompletableFuture.runAsync(() -> {
            InputStream stream = null;
            try {
                stream = FNURLUtil.getStream(url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            streamConsumer.accept(stream);
        });
    }

    public static CompletableFuture<Void> getResponseAsync(URL url, Consumer<String> stringConsumer) {
        return CompletableFuture.runAsync(() -> {
            String str = null;
            try {
                str = FNURLUtil.getResponse(url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            stringConsumer.accept(str);
        });
    }

    public static CompletableFuture<Void> getResponseByPOSTAsync(URL url, String body, String language, String contentType, Consumer<FNPair<String, Integer>> responseConsumer) {
        return CompletableFuture.runAsync(() -> {
            FNPair<String, Integer> ret = null;
            try {
                ret = FNURLUtil.getResponseByPOST(url, body, language, contentType);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            responseConsumer.accept(ret);
        });
    }

    public static FNPair<String, Integer> getResponseByPOST(URL url, String body, String language, String contentType) throws IOException {
        String line;
        HttpURLConnection con = FNURLUtil.getConnection(url);
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        con.setRequestProperty("Accept-Language", language);
        con.setRequestProperty("Content-Type", String.format("%s; charset=utf-8", contentType));
        con.setRequestProperty("Content-Length", String.valueOf(body.getBytes(StandardCharsets.UTF_8).length));
        OutputStream out = con.getOutputStream();
        out.write(body.getBytes(StandardCharsets.UTF_8));
        out.flush();
        con.connect();
        int sts = con.getResponseCode();
        StringBuilder sb = new StringBuilder();
        InputStream in = con.getInputStream();
        String encoding = con.getContentEncoding();
        if (null == encoding) {
            encoding = "UTF-8";
        }
        InputStreamReader inReader = new InputStreamReader(in, encoding);
        BufferedReader bufReader = new BufferedReader(inReader);
        while ((line = bufReader.readLine()) != null) {
            sb.append(line);
        }
        bufReader.close();
        inReader.close();
        in.close();
        return FNPair.of(sb.toString(), sts);
    }
}

