package dev.felnull.otyacraftengine.impl.fabric;

import com.google.common.collect.ImmutableSet;
import net.fabricmc.fabric.api.object.builder.v1.villager.VillagerProfessionBuilder;
import net.fabricmc.fabric.mixin.object.builder.PointOfInterestTypeAccessor;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3852;
import net.minecraft.class_4158;
import org.jetbrains.annotations.Nullable;

import java.util.Set;
import java.util.function.Predicate;

public class OERegistryExpectPlatformImpl {
    public static class_4158 createPoiType(class_2960 name, Set<class_2680> matchingStates, int maxTickets, int validRange) {
        return PointOfInterestTypeAccessor.callCreate(name.toString(), matchingStates, maxTickets, validRange);
    }

    public static class_4158 createPoiType(class_2960 name, Set<class_2680> matchingStates, Predicate<class_4158> predicate, int maxTickets, int validRange) {
        return PointOfInterestTypeAccessor.callCreate(name.toString(), matchingStates, maxTickets, predicate, validRange);
    }

    public static class_4158 registerPoiTypeBlockStates(class_4158 poiType) {
        return PointOfInterestTypeAccessor.callSetup(poiType);
    }

    public static Set<class_2680> getPoiTypeBlockStates(class_2248 block) {
        return class_4158.method_20356(block);
    }

    public static class_3852 createVillagerProfession(class_2960 name, class_4158 jobPoiType, ImmutableSet<class_1792> requestedItems, ImmutableSet<class_2248> secondaryPoi, @Nullable class_3414 workSound) {
        return VillagerProfessionBuilder.create().id(name).workstation(jobPoiType).harvestableItems(requestedItems).secondaryJobSites(secondaryPoi).workSound(workSound).build();
    }
}
