package dev.felnull.otyacraftengine.blockentity;

import dev.architectury.registry.registries.DeferredRegister;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.block.TestBlock;
import dev.felnull.otyacraftengine.inventory.TestMenu;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class TestBlockEntity extends OEBaseContainerBlockEntity {
    private static final class_2371<class_1799> ITEMS = class_2371.method_10213(0, class_1799.field_8037);
    public static class_2591<TestBlockEntity> TEST_BLOCKENTITY;
    private float roted;
    private float oldRoted;

    public TestBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(TEST_BLOCKENTITY, blockPos, blockState);
    }

    public static void init() {
        DeferredRegister<class_2591<?>> BLOCK_ENTITY_TYPES_REGISTER = DeferredRegister.create(OtyacraftEngine.MODID, class_2378.field_25073);
        TEST_BLOCKENTITY = class_2591.class_2592.method_20528(TestBlockEntity::new, TestBlock.TEST_BLOCK).method_11034(null);
        BLOCK_ENTITY_TYPES_REGISTER.register("test_block_entity", () -> TEST_BLOCKENTITY);
        BLOCK_ENTITY_TYPES_REGISTER.register();
    }

    public float getOldRoted() {
        return oldRoted;
    }

    public float getRoted() {
        return roted;
    }

    public void test() {
        sync();
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, TestBlockEntity blockEntity) {
        blockEntity.oldRoted = blockEntity.roted;
        blockEntity.roted += 3;

        if (!level.method_8608()) {
            blockEntity.sync();
        }
    }

    @Override
    public class_2487 getSyncData(class_3222 player, class_2487 tag) {
        //  tag.putFloat("roted", roted);
        //   tag.putFloat("oldRoted", oldRoted);
        return tag;
    }

    @Override
    public void onSync(class_2487 tag) {
        // this.roted = tag.getFloat("roted");
        //   this.oldRoted = tag.getFloat("oldRoted");
    }

    @Override
    public @NotNull class_2371<class_1799> getItems() {
        return ITEMS;
    }

    @Override
    protected class_2561 method_17823() {
        return TestBlock.TEST_BLOCK.method_9518();
    }

    @Override
    protected class_1703 method_5465(int i, @NotNull class_1661 inventory) {
        return new TestMenu(i, inventory, this, method_11016());
    }
}
