package dev.felnull.otyacraftengine.client.gui.components;

import dev.felnull.otyacraftengine.client.gui.TextureSpecifyLocation;
import dev.felnull.otyacraftengine.client.gui.components.base.OEBaseImageWidget;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class RadioButtonV2 extends OEBaseImageWidget {
    @Nullable
    private final Consumer<RadioButtonV2> onPress;
    @NotNull
    private final Supplier<Set<RadioButtonV2>> group;
    private boolean showLabel;
    private boolean checked;

    public RadioButtonV2(int x, int y, @NotNull class_2561 message, @Nullable Consumer<RadioButtonV2> onPress, @NotNull Supplier<Set<RadioButtonV2>> group, boolean showLabel) {
        this(x, y, 20, 20, message, onPress, group, showLabel, new TextureSpecifyLocation(WIDGETS, 0, 0, 20, 20));
    }

    public RadioButtonV2(int x, int y, int width, int height, @NotNull class_2561 message, @Nullable Consumer<RadioButtonV2> onPress, @NotNull Supplier<Set<RadioButtonV2>> group, boolean showLabel, @NotNull TextureSpecifyLocation texture) {
        super(x, y, width, height, "radio", message, texture);
        this.onPress = onPress;
        this.group = group;
        this.showLabel = showLabel;
    }

    @Override
    public void method_25359(@NotNull class_4587 poseStack, int i, int j, float f) {
        OERenderUtil.drawTexture(texture.location(), poseStack, field_22760, field_22761, texture.x() + (this.method_25367() ? 20 : 0), texture.y() + (this.checked ? 20 : 0), texture.width(), texture.height(), texture.sizeWidth(), texture.sizeHeight());
        this.method_25353(poseStack, mc, i, j);
        if (this.showLabel)
            drawTextBase(poseStack, this.method_25369(), this.field_22760 + 24, this.field_22761 + (this.field_22759 - 8) / 2, 14737632 | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
    }

    @Override
    public void onPress() {
        this.checked = true;
        for (RadioButtonV2 rdo : group.get()) {
            if (this != rdo)
                rdo.checked = false;
        }
        if (onPress != null)
            this.onPress.accept(this);
    }

    public boolean isShowLabel() {
        return showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public boolean isChecked() {
        return checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }
}
