/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.libs.de.javagl.obj;

import dev.felnull.otyacraftengine.libs.de.javagl.obj.FloatTuple;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.Obj;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.ObjFace;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.ObjGroup;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.ObjUtils;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.Objs;
import dev.felnull.otyacraftengine.libs.de.javagl.obj.ReadableObj;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class ObjSplitter {
    private static final Logger logger = Logger.getLogger(ObjSplitter.class.getName());
    private static final Level level = Level.FINE;
    private final Predicate<? super ReadableObj> splitPredicate;

    ObjSplitter(final int maxNumVertices) {
        this.splitPredicate = new Predicate<ReadableObj>(){

            @Override
            public boolean test(ReadableObj obj) {
                return obj.getNumVertices() > maxNumVertices;
            }
        };
    }

    List<Obj> split(ReadableObj obj) {
        boolean didSplit;
        if (!this.splitPredicate.test(obj)) {
            Obj singleObj = Objs.create();
            ObjUtils.add(obj, singleObj);
            return Collections.singletonList(singleObj);
        }
        List<Obj> currentObjs = ObjSplitter.splitSingle(obj);
        boolean bl = didSplit = currentObjs.size() > 1;
        while (didSplit) {
            didSplit = false;
            ArrayList<Obj> nextObjs = new ArrayList<Obj>();
            for (Obj currentObj : currentObjs) {
                if (this.splitPredicate.test(currentObj)) {
                    List<Obj> parts = ObjSplitter.splitSingle(currentObj);
                    nextObjs.addAll(parts);
                    if (parts.size() <= 1) continue;
                    didSplit = true;
                    continue;
                }
                nextObjs.add(currentObj);
            }
            currentObjs = nextObjs;
        }
        return currentObjs;
    }

    private static List<Obj> splitSingle(ReadableObj obj) {
        logger.log(level, "Splitting OBJ with " + obj.getNumVertices() + " vertices");
        Predicate<ObjFace> facePredicate = ObjSplitter.computeFacePredicate(obj);
        ArrayList<ObjFace> faces0 = new ArrayList<ObjFace>();
        ArrayList<ObjFace> faces1 = new ArrayList<ObjFace>();
        for (int i = 0; i < obj.getNumFaces(); ++i) {
            ObjFace face = obj.getFace(i);
            if (facePredicate.test(face)) {
                faces0.add(face);
                continue;
            }
            faces1.add(face);
        }
        if (faces0.isEmpty()) {
            return ObjSplitter.split(obj, faces1);
        }
        if (faces1.isEmpty()) {
            return ObjSplitter.split(obj, faces0);
        }
        logger.log(level, "Split OBJ with " + obj.getNumFaces() + " faces into " + faces0.size() + " and " + faces1.size() + " faces");
        Obj obj0 = ObjUtils.groupToObj(obj, ObjSplitter.asGroup(faces0), null);
        Obj obj1 = ObjUtils.groupToObj(obj, ObjSplitter.asGroup(faces1), null);
        return Arrays.asList(obj0, obj1);
    }

    private static List<Obj> split(ReadableObj obj, List<ObjFace> allFaces) {
        if (allFaces.size() <= 1) {
            Obj obj0 = ObjUtils.groupToObj(obj, ObjSplitter.asGroup(allFaces), null);
            return Arrays.asList(obj0);
        }
        int centerIndex = (allFaces.size() + 1) / 2;
        List<ObjFace> faces0 = allFaces.subList(0, centerIndex);
        List<ObjFace> faces1 = allFaces.subList(centerIndex, allFaces.size());
        Obj obj0 = ObjUtils.groupToObj(obj, ObjSplitter.asGroup(faces0), null);
        Obj obj1 = ObjUtils.groupToObj(obj, ObjSplitter.asGroup(faces1), null);
        return Arrays.asList(obj0, obj1);
    }

    private static ObjGroup asGroup(final List<? extends ObjFace> faces) {
        return new ObjGroup(){

            @Override
            public String getName() {
                return "default";
            }

            @Override
            public int getNumFaces() {
                return faces.size();
            }

            @Override
            public ObjFace getFace(int index) {
                return (ObjFace)faces.get(index);
            }
        };
    }

    private static Predicate<ObjFace> computeFacePredicate(final ReadableObj obj) {
        float[] centersX = ObjSplitter.computeFaceCenters(obj, 0);
        float[] centersY = ObjSplitter.computeFaceCenters(obj, 1);
        float[] centersZ = ObjSplitter.computeFaceCenters(obj, 2);
        final float meanX = ObjSplitter.arithmeticMean(centersX);
        final float meanY = ObjSplitter.arithmeticMean(centersY);
        final float meanZ = ObjSplitter.arithmeticMean(centersZ);
        float varianceX = ObjSplitter.variance(centersX, meanX);
        float varianceY = ObjSplitter.variance(centersY, meanY);
        float varianceZ = ObjSplitter.variance(centersZ, meanZ);
        if (varianceX >= varianceY && varianceX >= varianceZ) {
            return new Predicate<ObjFace>(){

                @Override
                public boolean test(ObjFace objFace) {
                    float faceCenterX = ObjSplitter.computeFaceCenter(obj, objFace, 0);
                    return faceCenterX >= meanX;
                }
            };
        }
        if (varianceY >= varianceX && varianceY >= varianceZ) {
            return new Predicate<ObjFace>(){

                @Override
                public boolean test(ObjFace objFace) {
                    float faceCenterY = ObjSplitter.computeFaceCenter(obj, objFace, 1);
                    return faceCenterY >= meanY;
                }
            };
        }
        return new Predicate<ObjFace>(){

            @Override
            public boolean test(ObjFace objFace) {
                float faceCenterZ = ObjSplitter.computeFaceCenter(obj, objFace, 2);
                return faceCenterZ >= meanZ;
            }
        };
    }

    private static float[] computeFaceCenters(ReadableObj obj, int component) {
        int n = obj.getNumFaces();
        float[] result = new float[n];
        for (int i = 0; i < n; ++i) {
            ObjFace face = obj.getFace(i);
            result[i] = ObjSplitter.computeFaceCenter(obj, face, component);
        }
        return result;
    }

    private static float computeFaceCenter(ReadableObj obj, ObjFace face, int component) {
        float sum = 0.0f;
        int n = face.getNumVertices();
        for (int i = 0; i < n; ++i) {
            int vertexIndex = face.getVertexIndex(i);
            FloatTuple vertex = obj.getVertex(vertexIndex);
            sum += vertex.get(component);
        }
        return sum / (float)n;
    }

    private static float arithmeticMean(float[] array) {
        float sum = 0.0f;
        for (float value : array) {
            sum += value;
        }
        return sum / (float)array.length;
    }

    private static float variance(float[] array, float mean) {
        float variance = 0.0f;
        for (int i = 0; i < array.length; ++i) {
            double difference = array[i] - mean;
            variance = (float)((double)variance + difference * difference);
        }
        return variance / (float)(array.length - 1);
    }

    private static interface Predicate<T> {
        public boolean test(T var1);
    }
}

