package dev.felnull.otyacraftengine.blockentity;

import dev.architectury.networking.NetworkManager;
import dev.felnull.otyacraftengine.networking.BlockEntityExistence;
import dev.felnull.otyacraftengine.networking.OEPackets;
import dev.felnull.otyacraftengine.util.OEPlayerUtil;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_3222;

public interface IClientSyncbleBlockEntity {
    public static void syncBlockEntity(class_2586 blockEntity) {
        if (blockEntity instanceof IClientSyncbleBlockEntity syncble) {
            class_2818 lch = (class_2818) blockEntity.method_10997().method_22350(blockEntity.method_11016());
            OEPlayerUtil.doPlayers(lch, player -> {
                class_2487 tag = syncble.getSyncData(player, new class_2487());
                if (tag != null)
                    NetworkManager.sendToPlayer(player, OEPackets.BLOCK_ENTITY_SYNC, new OEPackets.BlockEntitySyncMessage(BlockEntityExistence.getByBlockEntity(blockEntity), tag).toFBB());
            });
        }
    }

    class_2487 getSyncData(class_3222 player, class_2487 tag);

    void onSync(class_2487 tag);

    void sync();

}
