/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjl.math;

import dev.felnull.fnjl.math.FN3dLine;
import dev.felnull.fnjl.math.FNVec3d;
import java.util.Objects;

public class FNFace {
    private FNVec3d from;
    private FNVec3d to;

    public FNFace(double fromX, double fromY, double fromZ, double toX, double toY, double toZ) {
        this(new FNVec3d(fromX, fromY, fromZ), new FNVec3d(toX, toY, toZ));
    }

    public FNFace(FNVec3d from, FNVec3d to) {
        this.from = from;
        this.to = to;
    }

    public FNVec3d getFrom() {
        return this.from;
    }

    public FNVec3d getTo() {
        return this.to;
    }

    public void setTo(FNVec3d to) {
        this.to = to;
    }

    public void setFrom(FNVec3d from) {
        this.from = from;
    }

    public double getFromX() {
        return this.from.getX();
    }

    public double getFromY() {
        return this.from.getY();
    }

    public double getFromZ() {
        return this.from.getZ();
    }

    public double getToX() {
        return this.to.getX();
    }

    public double getToY() {
        return this.to.getY();
    }

    public double getToZ() {
        return this.to.getZ();
    }

    public FN3dLine getEdge(int num) {
        switch (num) {
            case 0: {
                return new FN3dLine(this.getFromX(), this.getFromY(), this.getFromZ(), this.getToX(), this.getFromY(), this.getToZ());
            }
            case 1: {
                return new FN3dLine(this.getToX(), this.getFromY(), this.getToZ(), this.getToX(), this.getToY(), this.getToZ());
            }
            case 2: {
                return new FN3dLine(this.getToX(), this.getToY(), this.getToZ(), this.getFromX(), this.getToY(), this.getFromZ());
            }
            case 3: {
                return new FN3dLine(this.getFromX(), this.getFromY(), this.getFromZ(), this.getFromX(), this.getToY(), this.getFromZ());
            }
        }
        throw new IllegalStateException("Invalid edge number");
    }

    public String toString() {
        return "FNFace{from=" + this.from + ", to=" + this.to + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FNFace fnFace = (FNFace)o;
        return Objects.equals(this.from, fnFace.from) && Objects.equals(this.to, fnFace.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }
}

