package dev.felnull.otyacraftengine.client.renderer.texture;

import dev.felnull.otyacraftengine.client.util.OETextureUtils;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public interface TextureLoadResult {
    class_2960 getLocation();

    boolean isLoading();

    boolean isError();

    boolean isSuccess();

    Exception getException();

    @NotNull
    default class_2960 of(@NotNull class_2960 loading, @NotNull class_2960 error) {
        if (isLoading()) return loading;
        if (isError()) return error;
        return getLocation();
    }

    @NotNull
    default class_2960 of(@NotNull class_2960 error) {
        return of(OETextureUtils.getLoadingIcon(), error);
    }

    @NotNull
    default class_2960 of() {
        return of(OETextureUtils.getLoadingIcon(), OETextureUtils.getErrorIcon());
    }

    TextureLoadProgress getProgress();
}
