/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.shape;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import dev.felnull.otyacraftengine.client.shape.ClientIVShapeManager;
import dev.felnull.otyacraftengine.shape.IkisugiVoxelShape;
import dev.felnull.otyacraftengine.shape.RotateAngledAxis;
import dev.felnull.otyacraftengine.shape.VoxelEdge;
import dev.felnull.otyacraftengine.shape.VoxelEntry;
import dev.felnull.otyacraftengine.shape.VoxelPose;
import dev.felnull.otyacraftengine.util.OEVoxelShapeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import org.apache.commons.lang3.ArrayUtils;

public class IkisugiVoxelShapes {
    private static final IkisugiVoxelShapes INSTANCE = new IkisugiVoxelShapes();

    public static IkisugiVoxelShapes getInstance() {
        return INSTANCE;
    }

    public class_265 getShapeFromJson(JsonObject shapeJson, class_2960 location) {
        JsonElement version = shapeJson.get("version");
        if (version != null && version.isJsonPrimitive()) {
            if (version.getAsInt() == 2) {
                return this.getShapeFromJsonV2(shapeJson, location);
            }
            if (version.getAsInt() == 3) {
                return this.getShapeFromJsonV3(shapeJson, location);
            }
            if (version.getAsInt() >= 4) {
                throw new IllegalStateException("Not support ikisugi voxel shape version: " + version.getAsInt());
            }
        }
        return this.getShapeFromJsonV1(shapeJson);
    }

    private class_265 getShapeFromJsonV1(JsonObject shapeJ) {
        ArrayList<class_265> shapes = new ArrayList<class_265>();
        for (JsonElement jshape : shapeJ.getAsJsonArray("shapes")) {
            JsonArray ja = jshape.getAsJsonArray();
            class_265 shape = OEVoxelShapeUtils.makeBox(ja.get(0).getAsDouble(), ja.get(1).getAsDouble(), ja.get(2).getAsDouble(), ja.get(3).getAsDouble(), ja.get(4).getAsDouble(), ja.get(5).getAsDouble());
            shapes.add(shape);
        }
        return OEVoxelShapeUtils.uniteBox(shapes);
    }

    private class_265 getShapeFromJsonV2(JsonObject shapeJ, class_2960 location) {
        ArrayList<class_265> shapes = new ArrayList<class_265>();
        for (JsonElement jshape : shapeJ.getAsJsonArray("shapes")) {
            JsonArray ja = jshape.getAsJsonArray();
            class_265 shape = OEVoxelShapeUtils.makeBox(ja.get(0).getAsDouble() * 16.0, ja.get(1).getAsDouble() * 16.0, ja.get(2).getAsDouble() * 16.0, ja.get(3).getAsDouble() * 16.0, ja.get(4).getAsDouble() * 16.0, ja.get(5).getAsDouble() * 16.0);
            shapes.add(shape);
        }
        class_265 shape = OEVoxelShapeUtils.uniteBox(shapes);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> {
            HashSet<VoxelEdge> edges = new HashSet<VoxelEdge>();
            for (JsonElement jshape : shapeJ.getAsJsonArray("edges")) {
                VoxelEdge ed = VoxelEdge.parse(jshape.getAsJsonArray());
                if (ed == null) continue;
                edges.add(ed);
            }
            ClientIVShapeManager.getInstance().addLegacyShapes(location, edges);
        });
        ((IkisugiVoxelShape)shape).setRenderEdges(new VoxelEntry(location));
        return shape;
    }

    private class_265 getShapeFromJsonV3(JsonObject shapeJ, class_2960 location) {
        class_2960 relocation;
        ArrayList<class_265> shapes = new ArrayList<class_265>();
        for (JsonElement jshape : shapeJ.getAsJsonArray("shapes")) {
            JsonArray ja = jshape.getAsJsonArray();
            class_265 shape = OEVoxelShapeUtils.makeBox(ja.get(0).getAsDouble() * 16.0, ja.get(1).getAsDouble() * 16.0, ja.get(2).getAsDouble() * 16.0, ja.get(3).getAsDouble() * 16.0, ja.get(4).getAsDouble() * 16.0, ja.get(5).getAsDouble() * 16.0);
            shapes.add(shape);
        }
        class_265 shape = OEVoxelShapeUtils.uniteBox(shapes);
        if (shapeJ.has("render_edges") && shapeJ.get("render_edges").isJsonPrimitive()) {
            String reloc = shapeJ.get("render_edges").getAsString();
            relocation = new class_2960(reloc);
        } else {
            relocation = location;
        }
        ((IkisugiVoxelShape)shape).setRenderEdges(new VoxelEntry(relocation));
        return shape;
    }

    public class_265 copy(class_265 target, IkisugiVoxelShape source) {
        ((IkisugiVoxelShape)target).setRenderEdges(source.getRenderEdges());
        return target;
    }

    public class_265 unite(class_265 target, class_265 ... shapes) {
        ArrayList<VoxelEntry> entries = new ArrayList<VoxelEntry>();
        for (class_265 shape : shapes) {
            VoxelEntry[] ve = ((IkisugiVoxelShape)shape).getRenderEdges();
            if (ve == null) continue;
            entries.addAll(Arrays.asList(ve));
        }
        ((IkisugiVoxelShape)target).setRenderEdges(entries.toArray(new VoxelEntry[0]));
        return target;
    }

    public class_265 unite(class_265 target, List<IkisugiVoxelShape> shapes) {
        ArrayList entries = new ArrayList();
        shapes.forEach(shape -> {
            VoxelEntry[] ve = shape.getRenderEdges();
            if (ve != null) {
                entries.addAll(Arrays.asList(ve));
            }
        });
        ((IkisugiVoxelShape)target).setRenderEdges(entries.toArray(new VoxelEntry[0]));
        return target;
    }

    public class_265 move(class_265 target, IkisugiVoxelShape source, double x, double y, double z) {
        if (source.getRenderEdges() == null) {
            return target;
        }
        x /= 16.0;
        y /= 16.0;
        z /= 16.0;
        ArrayList<VoxelEntry> entries = new ArrayList<VoxelEntry>();
        for (VoxelEntry renderEdge : source.getRenderEdges()) {
            VoxelPose pp = renderEdge.getPose();
            entries.add(new VoxelEntry(renderEdge.getLocation(), new VoxelPose(pp.x() + x, pp.y() + y, pp.z() + z, pp.axis())));
        }
        ((IkisugiVoxelShape)target).setRenderEdges(entries.toArray(new VoxelEntry[0]));
        return target;
    }

    public class_265 rotate(class_265 target, IkisugiVoxelShape source, RotateAngledAxis angledAxis) {
        ArrayList<VoxelEntry> entries = new ArrayList<VoxelEntry>();
        for (VoxelEntry renderEdge : source.getRenderEdges()) {
            VoxelPose pp = renderEdge.getPose();
            entries.add(new VoxelEntry(renderEdge.getLocation(), new VoxelPose(pp.x(), pp.y(), pp.z(), (RotateAngledAxis[])ArrayUtils.add((Object[])pp.axis(), (Object)((Object)angledAxis)))));
        }
        ((IkisugiVoxelShape)target).setRenderEdges(entries.toArray(new VoxelEntry[0]));
        return target;
    }
}

