/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.include.de.javagl.obj;

import dev.felnull.otyacraftengine.include.de.javagl.obj.FloatTuple;
import dev.felnull.otyacraftengine.include.de.javagl.obj.FloatTuples;
import dev.felnull.otyacraftengine.include.de.javagl.obj.ObjFace;
import dev.felnull.otyacraftengine.include.de.javagl.obj.ObjFaces;
import dev.felnull.otyacraftengine.include.de.javagl.obj.WritableObj;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;

public class BasicWritableObj
implements WritableObj {
    private Consumer<? super FloatTuple> vertexConsumer;
    private Consumer<? super FloatTuple> texCoordConsumer;
    private Consumer<? super FloatTuple> normalConsumer;
    private Consumer<? super ObjFace> faceConsumer;
    private Consumer<? super Collection<? extends String>> groupNamesConsumer;
    private Consumer<? super String> materialGroupNameConsumer;
    private Consumer<? super Collection<? extends String>> mtlFileNamesConsumer;

    public void setVertexConsumer(Consumer<? super FloatTuple> vertexConsumer) {
        this.vertexConsumer = vertexConsumer;
    }

    public void setTexCoordConsumer(Consumer<? super FloatTuple> texCoordConsumer) {
        this.texCoordConsumer = texCoordConsumer;
    }

    public void setNormalConsumer(Consumer<? super FloatTuple> normalConsumer) {
        this.normalConsumer = normalConsumer;
    }

    public void setFaceConsumer(Consumer<? super ObjFace> faceConsumer) {
        this.faceConsumer = faceConsumer;
    }

    public void setGroupNamesConsumer(Consumer<? super Collection<? extends String>> groupNamesConsumer) {
        this.groupNamesConsumer = groupNamesConsumer;
    }

    public void setMaterialGroupNameConsumer(Consumer<? super String> materialGroupNameConsumer) {
        this.materialGroupNameConsumer = materialGroupNameConsumer;
    }

    public void setMtlFileNamesConsumer(Consumer<? super Collection<? extends String>> mtlFileNamesConsumer) {
        this.mtlFileNamesConsumer = mtlFileNamesConsumer;
    }

    @Override
    public final void addVertex(FloatTuple vertex) {
        if (this.vertexConsumer != null) {
            this.vertexConsumer.accept(vertex);
        }
    }

    @Override
    public final void addVertex(float x, float y, float z) {
        this.addVertex(FloatTuples.create(x, y, z));
    }

    @Override
    public final void addTexCoord(FloatTuple texCoord) {
        if (this.texCoordConsumer != null) {
            this.texCoordConsumer.accept(texCoord);
        }
    }

    @Override
    public final void addTexCoord(float x) {
        this.addTexCoord(FloatTuples.create(x));
    }

    @Override
    public final void addTexCoord(float x, float y) {
        this.addTexCoord(FloatTuples.create(x, y));
    }

    @Override
    public final void addTexCoord(float x, float y, float z) {
        this.addTexCoord(FloatTuples.create(x, y, z));
    }

    @Override
    public final void addNormal(FloatTuple normal) {
        if (this.normalConsumer != null) {
            this.normalConsumer.accept(normal);
        }
    }

    @Override
    public final void addNormal(float x, float y, float z) {
        this.addNormal(FloatTuples.create(x, y, z));
    }

    @Override
    public final void setActiveGroupNames(Collection<? extends String> groupNames) {
        if (this.groupNamesConsumer != null) {
            this.groupNamesConsumer.accept(groupNames);
        }
    }

    @Override
    public final void setActiveMaterialGroupName(String materialGroupName) {
        if (this.materialGroupNameConsumer != null) {
            this.materialGroupNameConsumer.accept(materialGroupName);
        }
    }

    @Override
    public final void addFace(ObjFace face) {
        if (this.faceConsumer != null) {
            this.faceConsumer.accept(face);
        }
    }

    @Override
    public final void addFace(int ... v) {
        this.addFace(v, (int[])null, (int[])null);
    }

    @Override
    public final void addFaceWithTexCoords(int ... v) {
        this.addFace(v, v, (int[])null);
    }

    @Override
    public final void addFaceWithNormals(int ... v) {
        this.addFace(v, (int[])null, v);
    }

    @Override
    public final void addFaceWithAll(int ... v) {
        this.addFace(v, v, v);
    }

    @Override
    public final void addFace(int[] v, int[] vt, int[] vn) {
        Objects.requireNonNull(v, "The vertex indices are null");
        if (this.faceConsumer != null) {
            this.addFace(ObjFaces.create(v, vt, vn));
        }
    }

    @Override
    public final void setMtlFileNames(Collection<? extends String> mtlFileNames) {
        if (this.mtlFileNamesConsumer != null) {
            this.mtlFileNamesConsumer.accept(mtlFileNames);
        }
    }
}

