package dev.felnull.otyacraftengine.fabric.mixin.client;

import dev.felnull.otyacraftengine.client.event.OEClientEventHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Mixin(class_310.class)
public class MinecraftMixin {
    @Shadow
    @Nullable
    public class_638 level;

    @Shadow
    @org.jetbrains.annotations.Nullable
    public class_746 player;

    @Inject(method = "setLevel", at = @At("HEAD"))
    private void setLevel(class_638 clientLevel, CallbackInfo ci) {
        if (level != null)
            OEClientEventHooks.onLevelUnload(level);
    }

    @Inject(method = "clearLevel(Lnet/minecraft/client/gui/screens/Screen;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Minecraft;updateScreenAndTick(Lnet/minecraft/client/gui/screens/Screen;)V", ordinal = 0, shift = At.Shift.AFTER))
    private void clearLevel(class_437 screen, CallbackInfo ci) {
        if (this.level != null)
            OEClientEventHooks.onLevelUnload(level);
    }

    @Inject(method = "continueAttack", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/phys/BlockHitResult;getDirection()Lnet/minecraft/core/Direction;", shift = At.Shift.BEFORE), cancellable = true)
    private void continueAttack(boolean bl, CallbackInfo ci) {
        if (player != null && !OEClientEventHooks.onHandAttack(player.method_5998(class_1268.field_5808)))
            ci.cancel();
    }

    @Inject(method = "startAttack", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/phys/HitResult;getType()Lnet/minecraft/world/phys/HitResult$Type;", shift = At.Shift.BEFORE), cancellable = true)
    private void startAttack(CallbackInfoReturnable<Boolean> cir) {
        if (player != null && !OEClientEventHooks.onHandAttack(player.method_5998(class_1268.field_5808)))
            cir.cancel();
    }
}
