/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.entity;

import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import dev.felnull.otyacraftengine.client.entity.PlayerNameByUUIDResult;
import dev.felnull.otyacraftengine.client.entity.PlayerUUIDByNameResult;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.otyacraftengine.util.OEPlayerUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1068;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4844;
import net.minecraft.class_640;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientPlayerInfoManager {
    private static final ClientPlayerInfoManager INSTANCE = new ClientPlayerInfoManager();
    private static final class_310 mc = class_310.method_1551();
    private final Map<String, GameProfile> PLAYER_PROFILES = new HashMap<String, GameProfile>();
    private final Map<String, PlayerUUIDByNameResult> UUID_BY_NAME_ENTRY = new HashMap<String, PlayerUUIDByNameResult>();
    private final Map<UUID, PlayerNameByUUIDResult> NAME_BY_UUID_ENTRY = new HashMap<UUID, PlayerNameByUUIDResult>();
    private Function<String, class_2960> SKIN_TEXTURE_LOCATION_CACHE = this.createSkinTextureLocationCache();

    public static ClientPlayerInfoManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, GameProfile> map = this.PLAYER_PROFILES;
        synchronized (map) {
            this.PLAYER_PROFILES.clear();
        }
        this.SKIN_TEXTURE_LOCATION_CACHE = this.createSkinTextureLocationCache();
    }

    private Function<String, class_2960> createSkinTextureLocationCache() {
        return FNDataUtil.memoize(url -> {
            String hashStr = Hashing.sha1().hashUnencodedChars((CharSequence)FilenameUtils.getBaseName((String)url)).toString();
            return new class_2960("skins/" + hashStr);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GameProfile getLackProfileTolerance(@NotNull String name) {
        Map<String, GameProfile> map = this.PLAYER_PROFILES;
        synchronized (map) {
            if (this.PLAYER_PROFILES.containsKey(name)) {
                return this.PLAYER_PROFILES.get(name);
            }
            GameProfile gp = new GameProfile(null, name);
            this.PLAYER_PROFILES.put(name, gp);
            class_2631.method_11335((GameProfile)gp, p -> {
                Map<String, GameProfile> map = this.PLAYER_PROFILES;
                synchronized (map) {
                    this.PLAYER_PROFILES.put(name, (GameProfile)p);
                }
            });
            return gp;
        }
    }

    @NotNull
    public Optional<UUID> getUUIDByName(@NotNull String name) {
        UUID cr = this.getUUIDByNameClient(name);
        if (cr != null) {
            return Optional.of(cr);
        }
        return OEPlayerUtils.getUUIDByName(name);
    }

    @NotNull
    public CompletableFuture<Optional<UUID>> getUUIDByNameAsync(@NotNull String name) {
        UUID cr = this.getUUIDByNameClient(name);
        if (cr != null) {
            return CompletableFuture.completedFuture(Optional.of(cr));
        }
        return OEPlayerUtils.getUUIDByNameAsync(name);
    }

    private UUID getUUIDByNameClient(String name) {
        if (ClientPlayerInfoManager.mc.field_1724 != null) {
            if (ClientPlayerInfoManager.mc.field_1724.method_7334().getName().equals(name)) {
                return ClientPlayerInfoManager.mc.field_1724.method_7334().getId();
            }
            class_640 pl = ClientPlayerInfoManager.mc.field_1724.field_3944.method_2874(name);
            if (pl != null && pl.method_2966() != null) {
                return pl.method_2966().getId();
            }
        }
        return null;
    }

    @NotNull
    public Optional<String> getNameByUUID(@NotNull UUID uuid) {
        String cr = this.getNameByUUIDClient(uuid);
        if (cr != null) {
            return Optional.of(cr);
        }
        return OEPlayerUtils.getNameByUUID(uuid);
    }

    @NotNull
    public CompletableFuture<Optional<String>> getNameByUUIDAsync(@NotNull UUID uuid) {
        String cr = this.getNameByUUIDClient(uuid);
        if (cr != null) {
            return CompletableFuture.completedFuture(Optional.of(cr));
        }
        return OEPlayerUtils.getNameByUUIDAsync(uuid);
    }

    private String getNameByUUIDClient(UUID uuid) {
        if (ClientPlayerInfoManager.mc.field_1724 != null) {
            if (ClientPlayerInfoManager.mc.field_1724.method_7334().getId().equals(uuid)) {
                return ClientPlayerInfoManager.mc.field_1724.method_7334().getName();
            }
            class_640 pl = ClientPlayerInfoManager.mc.field_1724.field_3944.method_2871(uuid);
            if (pl != null && pl.method_2966() != null) {
                return pl.method_2966().getName();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PlayerUUIDByNameResult getUUIDByNameTolerance(@NotNull String name) {
        Map<String, PlayerUUIDByNameResult> map = this.UUID_BY_NAME_ENTRY;
        synchronized (map) {
            PlayerUUIDByNameResult ret = this.UUID_BY_NAME_ENTRY.get(name);
            if (ret == null) {
                ret = new PlayerUUIDByNameResult(null, true);
                this.UUID_BY_NAME_ENTRY.put(name, ret);
                this.getUUIDByNameAsync(name).thenAcceptAsync(uuid -> {
                    Map<String, PlayerUUIDByNameResult> map = this.UUID_BY_NAME_ENTRY;
                    synchronized (map) {
                        this.UUID_BY_NAME_ENTRY.put(name, new PlayerUUIDByNameResult(uuid.orElse(null), false));
                    }
                });
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PlayerNameByUUIDResult getNameByUUIDTolerance(@NotNull UUID uuid) {
        Map<UUID, PlayerNameByUUIDResult> map = this.NAME_BY_UUID_ENTRY;
        synchronized (map) {
            PlayerNameByUUIDResult ret = this.NAME_BY_UUID_ENTRY.get(uuid);
            if (ret == null) {
                ret = new PlayerNameByUUIDResult(null, true);
                this.NAME_BY_UUID_ENTRY.put(uuid, ret);
                this.getNameByUUIDAsync(uuid).thenAcceptAsync(name -> {
                    Map<UUID, PlayerNameByUUIDResult> map = this.NAME_BY_UUID_ENTRY;
                    synchronized (map) {
                        this.NAME_BY_UUID_ENTRY.put(uuid, new PlayerNameByUUIDResult(name.orElse(null), false));
                    }
                });
            }
            return ret;
        }
    }

    @Nullable
    public class_2960 getPlayerTexture(@NotNull MinecraftProfileTexture.Type type, @NotNull String name) {
        class_640 pl;
        if (ClientPlayerInfoManager.mc.field_1724 != null && (pl = ClientPlayerInfoManager.mc.field_1724.field_3944.method_2874(name)) != null) {
            return this.getTexture(pl, type);
        }
        GameProfile gp = this.getLackProfileTolerance(name);
        MinecraftProfileTexture tex = (MinecraftProfileTexture)mc.method_1582().method_4654(gp).get(type);
        if (tex != null) {
            class_2960 hr = this.SKIN_TEXTURE_LOCATION_CACHE.apply(tex.getUrl());
            class_1043 mt = class_1047.method_4540();
            class_1044 at = mc.method_1531().method_34590(hr, (class_1044)mt);
            if (at == mt) {
                return mc.method_1582().method_4656(tex, type);
            }
            return hr;
        }
        return type == MinecraftProfileTexture.Type.SKIN ? class_1068.method_4648((UUID)class_4844.method_43344((String)name)) : null;
    }

    @Nullable
    public class_2960 getPlayerTexture(@NotNull MinecraftProfileTexture.Type type, @NotNull UUID uuid) {
        class_640 pl;
        if (ClientPlayerInfoManager.mc.field_1724 != null && (pl = ClientPlayerInfoManager.mc.field_1724.field_3944.method_2871(uuid)) != null) {
            return this.getTexture(pl, type);
        }
        String name = this.getNameByUUIDTolerance(uuid).name();
        if (name != null) {
            return this.getPlayerTexture(type, name);
        }
        return type == MinecraftProfileTexture.Type.SKIN ? class_1068.method_4648((UUID)uuid) : null;
    }

    private class_2960 getTexture(class_640 playerInfo, MinecraftProfileTexture.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case MinecraftProfileTexture.Type.SKIN -> playerInfo.method_2968();
            case MinecraftProfileTexture.Type.CAPE -> playerInfo.method_2979();
            case MinecraftProfileTexture.Type.ELYTRA -> playerInfo.method_2957();
        };
    }
}

