package dev.felnull.otyacraftengine.fabric.data;

import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.RecipeProviderWrapper;
import dev.felnull.otyacraftengine.fabric.data.provider.WrappedFabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2446;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class CrossDataGeneratorAccessImpl implements CrossDataGeneratorAccess {
    private final FabricDataGenerator fabricDataGenerator;

    protected CrossDataGeneratorAccessImpl(FabricDataGenerator fabricDataGenerator) {
        this.fabricDataGenerator = fabricDataGenerator;
    }

    @Override
    public @NotNull class_2403 getVanillaGenerator() {
        return fabricDataGenerator;
    }

    @Override
    public void addProvider(@NotNull class_2405 dataProvider) {
        fabricDataGenerator.addProvider(dataProvider);
    }

    @Override
    public Mod getMod() {
        return Platform.getMod(fabricDataGenerator.getModId());
    }

    @Override
    public class_2446 createRecipeProvider(RecipeProviderWrapper recipeProviderWrapper) {
        return new WrappedFabricRecipeProvider(fabricDataGenerator, recipeProviderWrapper);
    }
}
