/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.fabric.client.model.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.fabric.client.model.OBJLoader;
import dev.felnull.otyacraftengine.fabric.client.model.OBJOption;
import dev.felnull.otyacraftengine.fabric.client.model.impl.OBJMtl;
import dev.felnull.otyacraftengine.fabric.client.model.impl.OBJMtlReader;
import dev.felnull.otyacraftengine.fabric.client.model.impl.OBJUnbakedModelModel;
import dev.felnull.otyacraftengine.include.de.javagl.obj.Obj;
import dev.felnull.otyacraftengine.include.de.javagl.obj.ObjReader;
import dev.felnull.otyacraftengine.include.de.javagl.obj.ObjUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_804;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OBJLoaderImpl
implements OBJLoader {
    public static OBJLoader INSTANCE = new OBJLoaderImpl();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_809.class, (Object)new class_809.class_810()).registerTypeAdapter(class_804.class, (Object)new class_804.class_805()).create();
    private static final String LOADER_ID = "forge:obj";

    @Override
    @Nullable
    public class_1100 loadModel(@NotNull class_3300 resourceManager, @NotNull class_2960 location) throws IOException {
        class_2960 modelPath = new class_2960(location.method_12836(), location.method_12832() + ".json");
        Optional<JsonElement> loader = this.getRootElement(resourceManager, modelPath, "loader");
        return loader.map(elm -> {
            if (elm.isJsonPrimitive() && elm.getAsJsonPrimitive().isString() && LOADER_ID.equals(elm.getAsString())) {
                try {
                    Optional<JsonElement> model = this.getRootElement(resourceManager, modelPath, "model");
                    return model.map(mname -> {
                        if (mname.isJsonPrimitive() && mname.getAsJsonPrimitive().isString()) {
                            try {
                                Optional<JsonElement> display = this.getRootElement(resourceManager, modelPath, "display");
                                OBJOption option = OBJOption.of(str -> {
                                    try {
                                        return this.getRootElement(resourceManager, modelPath, (String)str);
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                });
                                return this.loadModel(resourceManager, new class_2960(mname.getAsString()), (class_809)GSON.fromJson(display.orElseGet(JsonObject::new), class_809.class), option);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return null;
                    }).orElse(null);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }).orElse(null);
    }

    @Override
    @Nullable
    public class_1100 loadModel(@NotNull class_3300 resourceManager, @NotNull class_2960 location, @NotNull class_809 transforms, @NotNull OBJOption option) throws IOException {
        return resourceManager.method_14486(location).map(res -> {
            OBJUnbakedModelModel oBJUnbakedModelModel;
            block8: {
                InputStream stream = res.method_14482();
                try {
                    Obj obj = ObjUtils.convertToRenderable(ObjReader.read(stream));
                    oBJUnbakedModelModel = new OBJUnbakedModelModel(obj, this.loadMTL(resourceManager, location, obj.getMtlFileNames()), transforms, option);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                stream.close();
            }
            return oBJUnbakedModelModel;
        }).orElse(null);
    }

    private Map<String, OBJMtl> loadMTL(class_3300 resourceManager, class_2960 modelLocation, List<String> mtlNames) throws IOException {
        LinkedHashMap<String, OBJMtl> mtls = new LinkedHashMap<String, OBJMtl>();
        for (String name : mtlNames) {
            CharSequence[] pths = modelLocation.method_12832().split("/");
            pths[pths.length - 1] = name;
            String pth = String.join((CharSequence)"/", pths);
            class_2960 resourceId = new class_2960(modelLocation.method_12836(), pth);
            resourceManager.method_14486(resourceId).ifPresent(res -> {
                try (BufferedReader reader = res.method_43039();){
                    OBJMtlReader.read(reader).forEach(mtl -> mtls.put(mtl.getName(), (OBJMtl)mtl));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return mtls;
    }

    private Optional<JsonElement> getRootElement(class_3300 resourceManager, class_2960 modelPath, String name) throws IOException {
        while (modelPath != null) {
            Optional res = resourceManager.method_14486(modelPath);
            if (res.isEmpty()) {
                return Optional.empty();
            }
            InputStream stream = ((class_3298)res.get()).method_14482();
            try (InputStreamReader reader = new InputStreamReader(stream);){
                JsonObject rawModel = class_3518.method_15255((Reader)reader);
                if (rawModel.has(name)) {
                    Optional<JsonElement> optional = Optional.ofNullable(rawModel.get(name));
                    return optional;
                }
                if (rawModel.has("parent")) {
                    class_2960 modelId = new class_2960(rawModel.get("parent").getAsString());
                    modelPath = new class_2960(modelId.method_12836(), "models/" + modelId.method_12832() + ".json");
                    continue;
                }
                modelPath = null;
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return Optional.empty();
    }
}

