/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.renderer.texture.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.event.OEClientEventHooks;
import dev.felnull.otyacraftengine.client.renderer.texture.NativeTextureManager;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadProgress;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadResult;
import dev.felnull.otyacraftengine.client.renderer.texture.URLTextureManager;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.NativeTextureLoadResult;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.TextureLoadProgressImpl;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.URLTextureLoadResult;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNURLUtil;
import dev.felnull.otyacraftengine.util.OEPaths;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.class_310;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class URLTextureManagerImpl
implements URLTextureManager {
    public static final URLTextureManagerImpl INSTANCE = new URLTextureManagerImpl();
    private static final class_310 mc = class_310.method_1551();
    private static final Gson GSON = new Gson();
    private final Map<String, UUID> FILE_CACHE_TEXTURE_IDS = new HashMap<String, UUID>();
    private final Object FILE_CACHE_IO_LOCK = new Object();
    private final Map<String, URLTextureEntry> LOAD_URL_TEXTURE = new HashMap<String, URLTextureEntry>();
    private ExecutorService executorService = this.createExecutorService();
    private Function<String, String> HASH_CACHE = this.createHashMemoize();
    private boolean dirtyFileCache;
    private long lastSave = -1L;
    private long lastReload = -1L;

    public void init() {
        this.optimize();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Object object = this.FILE_CACHE_IO_LOCK;
        synchronized (object) {
            long st = System.currentTimeMillis();
            File fol = this.getFileCacheFolderPath().toFile();
            if (!fol.exists() && !fol.mkdirs()) {
                OtyacraftEngine.LOGGER.error("Failed to create url textures folder");
                return;
            }
            File urlIndex = this.getIndexPath().toFile();
            JsonObject index = new JsonObject();
            Map<String, UUID> map = this.FILE_CACHE_TEXTURE_IDS;
            synchronized (map) {
                this.FILE_CACHE_TEXTURE_IDS.forEach((url, id) -> {
                    String idStr = id.toString().replace("-", "");
                    File file = this.getFileCacheFolderPath().resolve(idStr).toFile();
                    if (file.exists()) {
                        index.addProperty(url, idStr);
                    }
                });
                this.dirtyFileCache = false;
            }
            urlIndex.getParentFile().mkdirs();
            try (OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(urlIndex)));){
                GSON.toJson((JsonElement)index, (Appendable)writer);
            }
            catch (IOException e) {
                OtyacraftEngine.LOGGER.error("Failed to save url textures index", (Throwable)e);
            }
            if (this.FILE_CACHE_TEXTURE_IDS.size() > 0) {
                OtyacraftEngine.LOGGER.info(String.format("Saved %s URL texture cache indexes in %s ms.", this.FILE_CACHE_TEXTURE_IDS.size(), System.currentTimeMillis() - st));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Object object = this.FILE_CACHE_IO_LOCK;
        synchronized (object) {
            JsonObject index;
            long st = System.currentTimeMillis();
            File urlIndex = this.getIndexPath().toFile();
            if (!urlIndex.exists()) {
                return;
            }
            try (InputStreamReader reader = new InputStreamReader(new BufferedInputStream(new FileInputStream(urlIndex)));){
                index = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            }
            catch (IOException e) {
                OtyacraftEngine.LOGGER.error("Failed to load url texture cache indexes", (Throwable)e);
                return;
            }
            Map<String, UUID> map = this.FILE_CACHE_TEXTURE_IDS;
            synchronized (map) {
                this.FILE_CACHE_TEXTURE_IDS.clear();
                index.entrySet().forEach(entry -> {
                    File file;
                    UUID uuid;
                    JsonElement v = (JsonElement)entry.getValue();
                    if (v != null && v.isJsonPrimitive() && v.getAsJsonPrimitive().isString() && (uuid = FNStringUtil.getUUIDFromNoHyphenStringNonThrow(v.getAsString())) != null && (file = this.getFileCacheFolderPath().resolve(v.getAsString()).toFile()).exists()) {
                        this.FILE_CACHE_TEXTURE_IDS.put((String)entry.getKey(), uuid);
                    }
                });
            }
            if (this.FILE_CACHE_TEXTURE_IDS.size() > 0) {
                OtyacraftEngine.LOGGER.info(String.format("Loaded %s URL texture cache indexes in %s ms.", this.FILE_CACHE_TEXTURE_IDS.size(), System.currentTimeMillis() - st));
            }
        }
    }

    public void clear() {
        this.executorService.shutdown();
        this.executorService = this.createExecutorService();
        this.HASH_CACHE = this.createHashMemoize();
    }

    private ExecutorService createExecutorService() {
        return new ThreadPoolExecutor(0, OtyacraftEngine.getConfig().getClientConfig().getUrlTextureConfig().getMaxLoaderCount(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("url-texture-loader-%d").daemon(true).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize() {
        long st = System.currentTimeMillis();
        File urlIndex = this.getIndexPath().toFile();
        if (!urlIndex.exists()) {
            return;
        }
        File fol = this.getFileCacheFolderPath().toFile();
        if (!fol.exists() || !fol.isDirectory()) {
            return;
        }
        File[] fils = fol.listFiles();
        if (fils == null) {
            return;
        }
        ArrayList<File> noExistFiles = new ArrayList<File>();
        Map<String, UUID> map = this.FILE_CACHE_TEXTURE_IDS;
        synchronized (map) {
            for (File fil : fils) {
                String name = fil.getName();
                boolean flg = false;
                UUID uuid = FNStringUtil.getUUIDFromNoHyphenStringNonThrow(name);
                if (uuid != null) {
                    flg = this.FILE_CACHE_TEXTURE_IDS.containsValue(uuid);
                }
                if (flg) continue;
                noExistFiles.add(fil);
            }
        }
        int ct = 0;
        for (File neFile : noExistFiles) {
            if (!neFile.delete()) continue;
            ++ct;
        }
        if (ct > 0) {
            OtyacraftEngine.LOGGER.info(String.format("Removed %s unnecessary URL Texture Cache files in %sms.", ct, System.currentTimeMillis() - st));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        if (URLTextureManagerImpl.mc.field_1687 == null) {
            return;
        }
        if (this.lastSave <= -1L) {
            this.lastSave = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.lastSave >= 180000L) {
            this.lastSave = System.currentTimeMillis();
            if (this.dirtyFileCache) {
                CompletableFuture.runAsync(() -> {
                    this.save();
                    this.lastSave = System.currentTimeMillis();
                }, this.executorService);
            }
        }
        if (this.lastReload <= -1L) {
            this.lastReload = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.lastReload >= 1200000L) {
            this.lastReload = System.currentTimeMillis();
            ArrayList<String> removes = new ArrayList<String>();
            Map<String, URLTextureEntry> map = this.LOAD_URL_TEXTURE;
            synchronized (map) {
                for (Map.Entry<String, URLTextureEntry> entry : this.LOAD_URL_TEXTURE.entrySet()) {
                    URLTextureEntry ret = entry.getValue();
                    if (!ret.result.isNeedReload() || !ret.result.isError() || ret.result.getLoadedTime() < 0L || System.currentTimeMillis() - ret.result.getLoadedTime() < 3600000L) continue;
                    removes.add(entry.getKey());
                }
                for (String remove : removes) {
                    this.LOAD_URL_TEXTURE.remove(remove);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TextureLoadResult getAndAsyncLoad(String url, boolean cached) {
        URLTextureEntry ret;
        String hash = this.HASH_CACHE.apply(url);
        Map<String, URLTextureEntry> map = this.LOAD_URL_TEXTURE;
        synchronized (map) {
            ret = this.LOAD_URL_TEXTURE.get(hash);
            if (ret == null) {
                URLTextureLoadResult result = new URLTextureLoadResult(null, false, -1L, null, null);
                ret = new URLTextureEntry(result, cached);
                ret.result.setProgress(new TextureLoadProgressImpl("Load waiting", 0, 0));
                this.LOAD_URL_TEXTURE.put(hash, ret);
                URLTextureEntry finalRet = ret;
                ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.loadUrlTexture(hash, url, () -> finalRet.cached, result::setProgress), this.executorService).thenApplyAsync(let -> {
                    if (let.ret != null) {
                        return new URLTextureLoadPipe2(null, null, null, let.ret);
                    }
                    InputStream stream = let.stream;
                    if (finalRet.cached) {
                        try {
                            this.writeCache((URLTextureLoadPipe)let);
                            stream = new FileInputStream(this.getFileCachePath(let.uuid).toFile());
                        }
                        catch (IOException e) {
                            return new URLTextureLoadPipe2(null, null, null, (Pair<String, URLTextureLoadResult>)Pair.of((Object)hash, (Object)new URLTextureLoadResult(e, true, null, let.uuid)));
                        }
                    }
                    return new URLTextureLoadPipe2(let.uuid, let.progress, stream, null);
                }, (Executor)this.executorService)).thenApplyAsync(let -> {
                    if (let.ret != null) {
                        return let.ret;
                    }
                    NativeTextureManager ntm = NativeTextureManager.getInstance();
                    NativeTextureLoadResult rat = ntm.getAndLoadTexture(let.uuid, let.stream, let.progress);
                    return Pair.of((Object)hash, (Object)new URLTextureLoadResult(null, false, rat, let.uuid));
                }, (Executor)this.executorService)).thenApplyAsync(lt -> {
                    String retHash = (String)lt.getKey();
                    URLTextureLoadResult retEntry = (URLTextureLoadResult)lt.getValue();
                    if (retEntry.getNativeResult() != null && retEntry.getNativeResult().getException() != null) {
                        retEntry = new URLTextureLoadResult(retEntry.getException(), true, null, retEntry.getUUID());
                    }
                    return Pair.of((Object)retHash, (Object)retEntry);
                }, (Executor)this.executorService)).thenAcceptAsync(let -> {
                    Map<String, URLTextureEntry> map = this.LOAD_URL_TEXTURE;
                    synchronized (map) {
                        this.LOAD_URL_TEXTURE.put((String)let.getKey(), new URLTextureEntry((URLTextureLoadResult)let.getValue(), finalRet.cached));
                    }
                }, (Executor)this.executorService);
            } else if (!ret.cached && cached) {
                ret.cached = true;
                if (ret.result.isSuccess()) {
                    URLTextureEntry finalRet1 = ret;
                    CompletableFuture.supplyAsync(() -> {
                        try {
                            Pair<InputStream, Long> cret = this.connect(url);
                            return new URLTextureLoadPipe(hash, finalRet1.result.getUUID(), (Long)cret.getRight(), null, (InputStream)cret.getLeft(), null);
                        }
                        catch (Exception ex) {
                            return null;
                        }
                    }, this.executorService).thenAcceptAsync(let -> {
                        if (let != null) {
                            try {
                                this.writeCache((URLTextureLoadPipe)let);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }, (Executor)this.executorService);
                }
            }
        }
        return ret.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLTextureLoadPipe loadUrlTexture(String hash, String url, BooleanSupplier cached, Consumer<TextureLoadProgress> progress) {
        InputStream stream;
        long length;
        UUID fileCache;
        try {
            this.checkUrl(url);
        }
        catch (Exception ex) {
            return new URLTextureLoadPipe(null, null, -1L, null, null, (Pair<String, URLTextureLoadResult>)Pair.of((Object)hash, (Object)new URLTextureLoadResult(ex, false, null, UUID.randomUUID())));
        }
        Map<String, UUID> map = this.FILE_CACHE_TEXTURE_IDS;
        synchronized (map) {
            fileCache = this.FILE_CACHE_TEXTURE_IDS.get(hash);
        }
        NativeTextureManager ntm = NativeTextureManager.getInstance();
        if (fileCache != null) {
            try {
                NativeTextureLoadResult ret = ntm.getAndLoadTexture(fileCache, new FileInputStream(this.getFileCachePath(fileCache).toFile()), progress);
                return new URLTextureLoadPipe(null, null, -1L, null, null, (Pair<String, URLTextureLoadResult>)Pair.of((Object)hash, (Object)new URLTextureLoadResult(null, false, ret, fileCache)));
            }
            catch (FileNotFoundException e) {
                Map<String, UUID> map2 = this.FILE_CACHE_TEXTURE_IDS;
                synchronized (map2) {
                    this.FILE_CACHE_TEXTURE_IDS.remove(hash);
                }
            }
        }
        UUID uuid = UUID.randomUUID();
        try {
            Pair<InputStream, Long> cret = this.connect(url);
            length = (Long)cret.getRight();
            stream = (InputStream)cret.getLeft();
        }
        catch (IOException e) {
            return new URLTextureLoadPipe(null, null, -1L, null, null, (Pair<String, URLTextureLoadResult>)Pair.of((Object)hash, (Object)new URLTextureLoadResult(e, true, null, uuid)));
        }
        return new URLTextureLoadPipe(hash, uuid, length, progress, stream, null);
    }

    private Pair<InputStream, Long> connect(String url) throws IOException {
        long max;
        HttpURLConnection con = FNURLUtil.getConnection(new URL(OEClientEventHooks.onSwapTextureURL(url)));
        long length = con.getContentLengthLong();
        if (length <= 0L) {
            length = 1L;
        }
        if (length > (max = 0xA00000L)) {
            throw new IOException("Size Over: " + max + "byte current: " + length + "byte");
        }
        return Pair.of((Object)con.getInputStream(), (Object)length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCache(URLTextureLoadPipe urlTextureLoadPipe) throws IOException {
        File fil = this.getFileCachePath(urlTextureLoadPipe.uuid).toFile();
        FNDataUtil.wishMkdir(fil.getParentFile());
        if (urlTextureLoadPipe.progress != null) {
            urlTextureLoadPipe.progress.accept(new TextureLoadProgressImpl("Cache getting", (int)urlTextureLoadPipe.length, 0));
        }
        try (InputStream inputStream = urlTextureLoadPipe.stream;){
            FNDataUtil.fileWriteToProgress(inputStream, urlTextureLoadPipe.length, fil, progressListener -> {
                if (urlTextureLoadPipe.progress != null) {
                    urlTextureLoadPipe.progress.accept(new TextureLoadProgressImpl("Cache getting", (int)progressListener.getWrittenLength(), (int)progressListener.getLength()));
                }
            });
        }
        if (urlTextureLoadPipe.progress != null) {
            urlTextureLoadPipe.progress.accept(new TextureLoadProgressImpl("Cache getting", (int)urlTextureLoadPipe.length, (int)urlTextureLoadPipe.length));
        }
        Map<String, UUID> map = this.FILE_CACHE_TEXTURE_IDS;
        synchronized (map) {
            this.FILE_CACHE_TEXTURE_IDS.put(urlTextureLoadPipe.hash, urlTextureLoadPipe.uuid);
            this.dirtyFileCache = true;
        }
    }

    private Path getIndexPath() {
        return OEPaths.getClientOEFolderPath().resolve("url_textures_index.json");
    }

    private Path getFileCacheFolderPath() {
        return OEPaths.getClientOEFolderPath().resolve("url_texture_cache");
    }

    private Path getFileCachePath(UUID uuid) {
        return this.getFileCacheFolderPath().resolve(uuid.toString().replace("-", ""));
    }

    private Function<String, String> createHashMemoize() {
        return FNDataUtil.memoize(n -> {
            try {
                byte[] md5 = FNDataUtil.createMD5Hash(n.getBytes(StandardCharsets.UTF_8));
                return new String(Hex.encodeHex((byte[])md5));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void checkUrl(String url) {
        boolean aflg;
        if (url.length() > 300) {
            throw new IllegalArgumentException("URL is too long");
        }
        boolean oea = Pattern.compile(OtyacraftEngine.getConfig().getClientConfig().getUrlTextureConfig().getUrlRegex()).matcher(url).matches();
        boolean eva = OEClientEventHooks.onCheckTextureURL(url);
        boolean bl = aflg = oea || eva;
        if (!aflg) {
            throw new IllegalArgumentException("Not allowed URL");
        }
    }

    private class URLTextureEntry {
        private URLTextureLoadResult result;
        private boolean cached;

        private URLTextureEntry(URLTextureLoadResult result, boolean cached) {
            this.result = result;
            this.cached = cached;
        }
    }

    private record URLTextureLoadPipe(String hash, UUID uuid, long length, @Nullable Consumer<TextureLoadProgress> progress, InputStream stream, Pair<String, URLTextureLoadResult> ret) {
    }

    private record URLTextureLoadPipe2(UUID uuid, Consumer<TextureLoadProgress> progress, InputStream stream, Pair<String, URLTextureLoadResult> ret) {
    }
}

