package dev.felnull.otyacraftengine.client.util;

import TextureScale;
import com.madgag.gif.fmsware.GifDecoder;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import dev.felnull.fnjl.math.FNVec2d;
import dev.felnull.fnjl.util.FNMath;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.entity.ClientPlayerInfoManager;
import dev.felnull.otyacraftengine.client.renderer.texture.*;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.NativeTextureLoadResult;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.TextureLoadProgressImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1061;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;

/**
 * テクスチャ関係のユーティリティ
 *
 * @author MORIMORI0317
 */
public class OETextureUtils {
    private static final class_310 mc = class_310.method_1551();
    private static final class_2960 ERROR_ICON = new class_2960(OtyacraftEngine.MODID, "textures/gui/error_icon.png");
    private static class_2960 LOADING_ICON;

    /**
     * ネイティブ画像のテクスチャを読み込む
     *
     * @param stream ストリーム
     * @return テクスチャ
     * @throws IOException 例外
     */
    @NotNull
    public static class_1043 createNativeTexture(@NotNull InputStream stream, @Nullable Consumer<TextureLoadProgress> progress) throws IOException {
        if (progress != null) progress.accept(new TextureLoadProgressImpl("Image loading", 1, 0));

        byte[] data = stream.readAllBytes();

        if (progress != null) progress.accept(new TextureLoadProgressImpl("Image loading", 1, 1));

        try (var istream = new ByteArrayInputStream(data)) {
            GifDecoder decoder = new GifDecoder();
            if (decoder.read(istream) == 0) return DynamicGifTexture.create(decoder, progress);
        }

        try (var istream = new ByteArrayInputStream(data)) {
            return new class_1043(class_1011.method_4309(istream));
        }
    }

    /**
     * テクスチャを開放する
     *
     * @param location テクスチャID
     */
    public synchronized static void freeTexture(@NotNull class_2960 location) {
        class_1060 textureManager = mc.method_1531();
        class_1044 abstractTexture = textureManager.field_5286.get(location);
        if (abstractTexture != null) {
            if (abstractTexture instanceof class_1061) textureManager.field_5284.remove(abstractTexture);
            textureManager.method_30299(location, abstractTexture);
        }
    }

    /**
     * 非同期でネイティブテクスチャの読み込みと取得をする
     *
     * @param uuid   UUID
     * @param stream ストリーム
     * @return テクスチャ結果
     */
    @NotNull
    public static NativeTextureLoadResult getAndLoadNativeTextureAsync(@NotNull UUID uuid, @NotNull InputStream stream) {
        return NativeTextureManager.getInstance().getAndLoadTextureAsync(uuid, stream);
    }

    /**
     * ネイティブテクスチャの読み込みと取得をする
     *
     * @param uuid   UUID
     * @param stream ストリーム
     * @return テクスチャ結果
     */
    @NotNull
    public static NativeTextureLoadResult getAndLoadNativeTexture(@NotNull UUID uuid, @NotNull InputStream stream) {
        return NativeTextureManager.getInstance().getAndLoadTexture(uuid, stream);
    }

    /**
     * ネイティブテクスチャを取得
     *
     * @param uuid UUID
     * @return テクスチャ結果
     */
    @Nullable
    public static NativeTextureLoadResult getNativeTexture(@NotNull UUID uuid) {
        return NativeTextureManager.getInstance().getTexture(uuid);
    }

    /**
     * 非同期でURLテクスチャの読み込みと取得をする
     *
     * @param url    URL
     * @param cached キャッシュするかどうか
     * @return テクスチャ結果
     */
    @NotNull
    public static TextureLoadResult getAndLoadURLTextureAsync(@NotNull String url, boolean cached) {
        return URLTextureManager.getInstance().getAndAsyncLoad(url, cached);
    }

    /**
     * ロード中アイコンを取得
     *
     * @return ロケーション
     */
    @NotNull
    public static class_2960 getLoadingIcon() {
        if (LOADING_ICON == null) {
            class_3300 rm = mc.method_1478();
            var r = rm.method_14486(new class_2960(OtyacraftEngine.MODID, "textures/gui/loading_icon.gif"));
            if (r.isPresent()) {
                try (var st = r.get().method_14482()) {
                    var ret = getAndLoadNativeTexture(UUID.randomUUID(), st);
                    if (ret.isSuccess()) LOADING_ICON = ret.getLocation();
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (LOADING_ICON == null) throw new IllegalStateException("Failed to loading icon being loaded.");
        }

        return LOADING_ICON;
    }

    /**
     * エラーアイコン
     *
     * @return ロケーション
     */
    @NotNull
    public static class_2960 getErrorIcon() {
        return ERROR_ICON;
    }

    /**
     * UUIDからプレイヤーテクスチャ取得
     * 存在しない場合はnullを返す
     *
     * @param type テクスチャタイプ
     * @param uuid プレイヤーUUID
     * @return プレイヤーテクスチャロケーション
     * @since 2.0
     */
    @Nullable
    public static class_2960 getPlayerTexture(MinecraftProfileTexture.Type type, @NotNull UUID uuid) {
        return ClientPlayerInfoManager.getInstance().getPlayerTexture(type, uuid);
    }

    /**
     * 名前からプレイヤーテクスチャ取得
     * 存在しない場合はnullを返す
     *
     * @param type テクスチャタイプ
     * @param name プレイヤー名
     * @return プレイヤーテクスチャロケーション
     */
    @Nullable
    public static class_2960 getPlayerTexture(MinecraftProfileTexture.Type type, @NotNull String name) {
        return ClientPlayerInfoManager.getInstance().getPlayerTexture(type, name);
    }

    /**
     * 名前からプレイヤーエリトラテクスチャ取得
     * 存在しない場合はnullを返す
     *
     * @param name プレイヤー名
     * @return プレイヤーエリトラテクスチャID
     */
    @Nullable
    public static class_2960 getPlayerElytraTexture(@NotNull String name) {
        return getPlayerTexture(MinecraftProfileTexture.Type.ELYTRA, name);
    }

    /**
     * 名前からプレイヤーマントテクスチャ取得
     * 存在しない場合はnullを返す
     *
     * @param name プレイヤー名
     * @return プレイヤーマントテクスチャID
     */
    @Nullable
    public static class_2960 getPlayerCapeTexture(@NotNull String name) {
        return getPlayerTexture(MinecraftProfileTexture.Type.CAPE, name);
    }

    /**
     * 名前からプレイヤースキンテクスチャ取得
     *
     * @param name プレイヤー名
     * @return プレイヤースキンテクスチャID
     */
    @NotNull
    public static class_2960 getPlayerSkinTexture(@NotNull String name) {
        return Objects.requireNonNull(getPlayerTexture(MinecraftProfileTexture.Type.SKIN, name));
    }

    /**
     * UUIDからプレイヤーエリトラテクスチャ取得
     * 存在しない場合はnullを返す
     *
     * @param uuid プレイヤーUUID
     * @return プレイヤーエリトラテクスチャID
     * @since 2.0
     */
    @Nullable
    public static class_2960 getPlayerElytraTexture(@NotNull UUID uuid) {
        return getPlayerTexture(MinecraftProfileTexture.Type.ELYTRA, uuid);
    }

    /**
     * UUIDからプレイヤーマントテクスチャ取得
     * 存在しない場合はnullを返す
     *
     * @param uuid プレイヤーUUID
     * @return プレイヤーマントテクスチャID
     * @since 2.0
     */
    @Nullable
    public static class_2960 getPlayerCapeTexture(@NotNull UUID uuid) {
        return getPlayerTexture(MinecraftProfileTexture.Type.CAPE, uuid);
    }

    /**
     * UUIDからプレイヤースキンテクスチャ取得
     *
     * @param uuid プレイヤーUUID
     * @return プレイヤースキンテクスチャID
     * @since 2.0
     */
    @NotNull
    public static class_2960 getPlayerSkinTexture(@NotNull UUID uuid) {
        return Objects.requireNonNull(getPlayerTexture(MinecraftProfileTexture.Type.SKIN, uuid));
    }

    /**
     * テクスチャのスケールを取得
     *
     * @param location テクスチャロケーション
     * @return スケール
     */
    public static TextureScale getTextureScale(class_2960 location) {
        if (location != null && mc.method_1531().method_4619(location) instanceof class_1043 texture) {
            int w = texture.method_4525().method_4307();
            int h = texture.method_4525().method_4323();
            var sc = FNMath.scale(w, h);
            return new TextureScale(sc.getX(), sc.getY());
        }
        return null;
    }
}
