/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.renderer.texture.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.event.OEClientEventHooks;
import dev.felnull.otyacraftengine.client.renderer.texture.NativeTextureManager;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadProgress;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadResult;
import dev.felnull.otyacraftengine.client.renderer.texture.URLTextureManager;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.NativeTextureLoadResult;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.TextureLoadProgressImpl;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.URLTextureLoadResult;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.otyacraftengine.util.FlagThread;
import dev.felnull.otyacraftengine.util.OEPaths;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.class_310;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.tuple.Pair;

public class URLTextureManagerOldImpl
implements URLTextureManager {
    public static final URLTextureManagerOldImpl INSTANCE = new URLTextureManagerOldImpl();
    private static final class_310 mc = class_310.method_1551();
    private static final Gson GSON = new Gson();
    private final Map<String, UUID> FILE_CACHE_TEXTURE_IDS = new HashMap<String, UUID>();
    private final Map<String, URLTextureLoadResult> LOAD_URL_TEXTURE = new HashMap<String, URLTextureLoadResult>();
    private final List<URLTextureLoader> URL_TEXTURE_LOADERS = new ArrayList<URLTextureLoader>();
    private final List<LoadURLEntry> WAIT_LOAD_URLS = new ArrayList<LoadURLEntry>();
    private final List<LoadURLEntry> REMOVE_WAIT_URLS = new ArrayList<LoadURLEntry>();
    private Function<String, String> HASH_CACHE = this.createHashMemoize();
    private boolean dirtyFileCache;
    private long lastSave = -1L;
    private long lastReload = -1L;
    private URLTextureSaveThread saveThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TextureLoadResult getAndAsyncLoad(String url, boolean cached) {
        String hash = this.HASH_CACHE.apply(url);
        Map<String, URLTextureLoadResult> map = this.LOAD_URL_TEXTURE;
        synchronized (map) {
            URLTextureLoadResult ret = this.LOAD_URL_TEXTURE.get(hash);
            if (ret == null) {
                ret = new URLTextureLoadResult(null, false, -1L, null, null);
                ret.setProgress(new TextureLoadProgressImpl("Load waiting", this.LOAD_URL_TEXTURE.size(), 0));
                this.LOAD_URL_TEXTURE.put(hash, ret);
                List<LoadURLEntry> list = this.WAIT_LOAD_URLS;
                synchronized (list) {
                    this.WAIT_LOAD_URLS.add(new LoadURLEntry(url, cached));
                }
            }
            return ret;
        }
    }

    public void init() {
        this.loadIndex();
        this.optimizationFileCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        if (URLTextureManagerOldImpl.mc.field_1687 == null) {
            return;
        }
        List<LoadURLEntry> list = this.WAIT_LOAD_URLS;
        synchronized (list) {
            int ct = 0;
            int lt = Math.max(OtyacraftEngine.getConfig().getClientConfig().getUrlTextureConfig().getMaxLoaderCount() - this.URL_TEXTURE_LOADERS.size(), 0);
            for (LoadURLEntry waitUrl : this.WAIT_LOAD_URLS) {
                if (ct >= lt) break;
                this.REMOVE_WAIT_URLS.add(waitUrl);
                ++ct;
            }
            for (LoadURLEntry rwu : this.REMOVE_WAIT_URLS) {
                URLTextureLoadResult ret;
                this.WAIT_LOAD_URLS.remove(rwu);
                Map<String, URLTextureLoadResult> map = this.LOAD_URL_TEXTURE;
                synchronized (map) {
                    ret = this.LOAD_URL_TEXTURE.get(this.HASH_CACHE.apply(rwu.url));
                }
                ret.setProgress(new TextureLoadProgressImpl("Load waiting", this.LOAD_URL_TEXTURE.size(), this.LOAD_URL_TEXTURE.size()));
                URLTextureLoader loader = new URLTextureLoader(rwu.url, rwu.cached, ret);
                loader.start();
                this.URL_TEXTURE_LOADERS.add(loader);
            }
            this.REMOVE_WAIT_URLS.clear();
        }
        if (this.lastSave <= -1L) {
            this.lastSave = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.lastSave >= 180000L) {
            this.lastSave = System.currentTimeMillis();
            if (this.dirtyFileCache && this.saveThread == null) {
                this.saveThread = new URLTextureSaveThread();
                this.saveThread.start();
            }
        }
        if (this.lastReload <= -1L) {
            this.lastReload = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.lastReload >= 1200000L) {
            this.lastReload = System.currentTimeMillis();
            ArrayList<String> removes = new ArrayList<String>();
            Map<String, URLTextureLoadResult> map = this.LOAD_URL_TEXTURE;
            synchronized (map) {
                for (Map.Entry<String, URLTextureLoadResult> entry : this.LOAD_URL_TEXTURE.entrySet()) {
                    URLTextureLoadResult ret = entry.getValue();
                    if (!ret.isNeedReload() || !ret.isError() || ret.getLoadedTime() < 0L || System.currentTimeMillis() - ret.getLoadedTime() < 3600000L) continue;
                    removes.add(entry.getKey());
                }
                for (String remove : removes) {
                    this.LOAD_URL_TEXTURE.remove(remove);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWaitProgress() {
        Map<String, URLTextureLoadResult> map = this.LOAD_URL_TEXTURE;
        synchronized (map) {
            for (URLTextureLoadResult value : this.LOAD_URL_TEXTURE.values()) {
                value.setProgress(new TextureLoadProgressImpl(value.getProgress().getStateName(), value.getProgress().getTotal(), value.getProgress().getComplete() + 1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveIndex() {
        long st = System.currentTimeMillis();
        File fol = this.getFileCacheFolderPath().toFile();
        if (!fol.exists() && !fol.mkdirs()) {
            OtyacraftEngine.LOGGER.error("Failed to create url textures folder");
            return;
        }
        File urlIndex = this.getIndexPath().toFile();
        JsonObject index = new JsonObject();
        Map<String, UUID> map = this.FILE_CACHE_TEXTURE_IDS;
        synchronized (map) {
            this.FILE_CACHE_TEXTURE_IDS.forEach((url, id) -> {
                String idStr = id.toString().replace("-", "");
                File file = this.getFileCacheFolderPath().resolve(idStr).toFile();
                if (file.exists()) {
                    index.addProperty(url, idStr);
                }
            });
            this.dirtyFileCache = false;
        }
        urlIndex.getParentFile().mkdirs();
        try (OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(urlIndex)));){
            GSON.toJson((JsonElement)index, (Appendable)writer);
        }
        catch (IOException e) {
            OtyacraftEngine.LOGGER.error("Failed to save url textures index", (Throwable)e);
        }
        if (this.FILE_CACHE_TEXTURE_IDS.size() > 0) {
            OtyacraftEngine.LOGGER.info(String.format("Saved %s URL texture cache indexes in %s ms.", this.FILE_CACHE_TEXTURE_IDS.size(), System.currentTimeMillis() - st));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadIndex() {
        JsonObject index;
        long st = System.currentTimeMillis();
        File urlIndex = this.getIndexPath().toFile();
        if (!urlIndex.exists()) {
            return;
        }
        try (InputStreamReader reader = new InputStreamReader(new BufferedInputStream(new FileInputStream(urlIndex)));){
            index = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        catch (IOException e) {
            OtyacraftEngine.LOGGER.error("Failed to load url texture cache indexes", (Throwable)e);
            return;
        }
        Map<String, UUID> map = this.FILE_CACHE_TEXTURE_IDS;
        synchronized (map) {
            this.FILE_CACHE_TEXTURE_IDS.clear();
            index.entrySet().forEach(entry -> {
                File file;
                UUID uuid;
                JsonElement v = (JsonElement)entry.getValue();
                if (v != null && v.isJsonPrimitive() && v.getAsJsonPrimitive().isString() && (uuid = FNStringUtil.getUUIDFromNoHyphenStringNonThrow(v.getAsString())) != null && (file = this.getFileCacheFolderPath().resolve(v.getAsString()).toFile()).exists()) {
                    this.FILE_CACHE_TEXTURE_IDS.put((String)entry.getKey(), uuid);
                }
            });
        }
        if (this.FILE_CACHE_TEXTURE_IDS.size() > 0) {
            OtyacraftEngine.LOGGER.info(String.format("Loaded %s URL texture cache indexes in %s ms.", this.FILE_CACHE_TEXTURE_IDS.size(), System.currentTimeMillis() - st));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimizationFileCache() {
        long st = System.currentTimeMillis();
        File urlIndex = this.getIndexPath().toFile();
        if (!urlIndex.exists()) {
            return;
        }
        File fol = this.getFileCacheFolderPath().toFile();
        if (!fol.exists() || !fol.isDirectory()) {
            return;
        }
        File[] fils = fol.listFiles();
        if (fils == null) {
            return;
        }
        ArrayList<File> noExistFiles = new ArrayList<File>();
        Map<String, UUID> map = this.FILE_CACHE_TEXTURE_IDS;
        synchronized (map) {
            for (File fil : fils) {
                String name = fil.getName();
                boolean flg = false;
                UUID uuid = FNStringUtil.getUUIDFromNoHyphenStringNonThrow(name);
                if (uuid != null) {
                    flg = this.FILE_CACHE_TEXTURE_IDS.containsValue(uuid);
                }
                if (flg) continue;
                noExistFiles.add(fil);
            }
        }
        int ct = 0;
        for (File neFile : noExistFiles) {
            if (!neFile.delete()) continue;
            ++ct;
        }
        if (ct > 0) {
            OtyacraftEngine.LOGGER.info(String.format("Removed %s unnecessary URL Texture Cache files in %sms.", ct, System.currentTimeMillis() - st));
        }
    }

    public void reload() {
        this.saveIndex();
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        this.HASH_CACHE = this.createHashMemoize();
        List<LoadURLEntry> list = this.URL_TEXTURE_LOADERS;
        synchronized (list) {
            this.URL_TEXTURE_LOADERS.forEach(utl -> {
                if (utl != null) {
                    utl.stopped();
                }
            });
            this.URL_TEXTURE_LOADERS.clear();
        }
        list = this.LOAD_URL_TEXTURE;
        synchronized (list) {
            for (URLTextureLoadResult value : this.LOAD_URL_TEXTURE.values()) {
                if (value.getUUID() == null) continue;
                NativeTextureManager.getInstance().freeNativeTexture(value.getUUID());
            }
            this.LOAD_URL_TEXTURE.clear();
        }
        list = this.WAIT_LOAD_URLS;
        synchronized (list) {
            this.WAIT_LOAD_URLS.clear();
        }
    }

    private Path getIndexPath() {
        return OEPaths.getClientOEFolderPath().resolve("url_textures_index.json");
    }

    private Path getFileCacheFolderPath() {
        return OEPaths.getClientOEFolderPath().resolve("url_texture_cache");
    }

    private Path getFileCachePath(UUID uuid) {
        return this.getFileCacheFolderPath().resolve(uuid.toString().replace("-", ""));
    }

    private Function<String, String> createHashMemoize() {
        return FNDataUtil.memoize(n -> {
            try {
                byte[] md5 = FNDataUtil.createMD5Hash(n.getBytes(StandardCharsets.UTF_8));
                return new String(Hex.encodeHex((byte[])md5));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void checkUrl(String url) {
        boolean aflg;
        if (url.length() > 300) {
            throw new IllegalArgumentException("URL is too long");
        }
        boolean oea = Pattern.compile(OtyacraftEngine.getConfig().getClientConfig().getUrlTextureConfig().getUrlRegex()).matcher(url).matches();
        boolean eva = OEClientEventHooks.onCheckTextureURL(url);
        boolean bl = aflg = oea || eva;
        if (!aflg) {
            throw new IllegalArgumentException("Not allowed URL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<String, URLTextureLoadResult> loadUrlTexture(String url, boolean cached, Consumer<TextureLoadProgress> progress) {
        long length;
        InputStream stream;
        UUID fileCache;
        String hash = this.HASH_CACHE.apply(url);
        try {
            this.checkUrl(url);
        }
        catch (Exception ex) {
            return Pair.of((Object)hash, (Object)new URLTextureLoadResult(ex, false, null, UUID.randomUUID()));
        }
        Map<String, UUID> map = this.FILE_CACHE_TEXTURE_IDS;
        synchronized (map) {
            fileCache = this.FILE_CACHE_TEXTURE_IDS.get(hash);
        }
        NativeTextureManager ntm = NativeTextureManager.getInstance();
        if (fileCache != null) {
            try {
                NativeTextureLoadResult ret = ntm.getAndLoadTexture(fileCache, new FileInputStream(this.getFileCachePath(fileCache).toFile()), progress);
                return Pair.of((Object)hash, (Object)new URLTextureLoadResult(null, false, ret, fileCache));
            }
            catch (FileNotFoundException e) {
                Map<String, UUID> map2 = this.FILE_CACHE_TEXTURE_IDS;
                synchronized (map2) {
                    this.FILE_CACHE_TEXTURE_IDS.remove(hash);
                }
            }
        }
        UUID uuid = UUID.randomUUID();
        try {
            Pair<InputStream, Long> con = this.connect(url);
            stream = (InputStream)con.getLeft();
            length = (Long)con.getRight();
        }
        catch (IOException e) {
            return Pair.of((Object)hash, (Object)new URLTextureLoadResult(e, true, null, uuid));
        }
        if (cached) {
            try {
                File fil = this.getFileCachePath(uuid).toFile();
                fil.getParentFile().mkdirs();
                progress.accept(new TextureLoadProgressImpl("Cache getting", (int)length, 0));
                try (InputStream inputStream = stream;){
                    FNDataUtil.fileWriteToProgress(inputStream, length, fil, progressListener -> progress.accept(new TextureLoadProgressImpl("Cache getting", (int)progressListener.getWrittenLength(), (int)progressListener.getLength())));
                }
                progress.accept(new TextureLoadProgressImpl("Cache getting", (int)length, (int)length));
                stream = new FileInputStream(this.getFileCachePath(uuid).toFile());
                Map<String, UUID> map3 = this.FILE_CACHE_TEXTURE_IDS;
                synchronized (map3) {
                    this.FILE_CACHE_TEXTURE_IDS.put(hash, uuid);
                    this.dirtyFileCache = true;
                }
            }
            catch (IOException e) {
                return Pair.of((Object)hash, (Object)new URLTextureLoadResult(e, true, null, uuid));
            }
        }
        NativeTextureLoadResult ret = ntm.getAndLoadTexture(uuid, stream, progress);
        return Pair.of((Object)hash, (Object)new URLTextureLoadResult(null, false, ret, uuid));
    }

    /*
     * Exception decompiling
     */
    private Pair<InputStream, Long> connect(String url) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private record LoadURLEntry(String url, boolean cached) {
    }

    private class URLTextureLoader
    extends FlagThread {
        private final String url;
        private final boolean cached;
        private final URLTextureLoadResult result;

        private URLTextureLoader(String url, boolean cached, URLTextureLoadResult result) {
            this.url = url;
            this.cached = cached;
            this.result = result;
            this.setName(OtyacraftEngine.getModName() + "-URL texture loader thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.isStopped()) {
                this.finished();
                return;
            }
            Pair<String, URLTextureLoadResult> ret = URLTextureManagerOldImpl.this.loadUrlTexture(this.url, this.cached, this.result::setProgress);
            String retHash = (String)ret.getKey();
            URLTextureLoadResult retEntry = (URLTextureLoadResult)ret.getValue();
            if (retEntry.getNativeResult() != null && retEntry.getNativeResult().getException() != null) {
                retEntry = new URLTextureLoadResult(retEntry.getException(), true, null, retEntry.getUUID());
            }
            if (this.isStopped()) {
                if (retEntry.getUUID() != null) {
                    NativeTextureManager.getInstance().freeNativeTexture(retEntry.getUUID());
                }
                this.finished();
                return;
            }
            Map<String, URLTextureLoadResult> map = URLTextureManagerOldImpl.this.LOAD_URL_TEXTURE;
            synchronized (map) {
                URLTextureManagerOldImpl.this.LOAD_URL_TEXTURE.put(retHash, retEntry);
            }
            this.finished();
        }

        private void finished() {
            URLTextureManagerOldImpl.this.URL_TEXTURE_LOADERS.remove(this);
            URLTextureManagerOldImpl.this.updateWaitProgress();
        }
    }

    private class URLTextureSaveThread
    extends Thread {
        private URLTextureSaveThread() {
            this.setName("OtyacraftEngine-URLTextureSave thread");
        }

        @Override
        public void run() {
            URLTextureManagerOldImpl.this.saveIndex();
            URLTextureManagerOldImpl.this.lastSave = System.currentTimeMillis();
            URLTextureManagerOldImpl.this.saveThread = null;
        }
    }
}

