package dev.felnull.otyacraftengine.fabric.data.provider;

import TagAppender;
import dev.felnull.otyacraftengine.data.provider.TagProviderWrapper;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class WrappedFabricTagProvider<T> extends FabricTagProvider<T> {
    private final TagProviderWrapper<T, TagProviderWrapper.TagProviderAccess<T>> tagProviderWrapper;

    public WrappedFabricTagProvider(FabricDataGenerator dataGenerator, class_2378<T> registry, TagProviderWrapper<T, TagProviderWrapper.TagProviderAccess<T>> tagProviderWrapper) {
        super(dataGenerator, registry);
        this.tagProviderWrapper = tagProviderWrapper;
    }

    @Override
    protected void generateTags() {
        this.tagProviderWrapper.generateTag(new TagProviderAccessImpl());
    }

    private class TagProviderAccessImpl implements TagProviderWrapper.TagProviderAccess<T> {
        @Override
        public TagProviderWrapper.TagAppenderWrapper<T> tag(class_6862<T> tagKey) {
            return new TagAppenderWrapperImpl<>(WrappedFabricTagProvider.this.tag(tagKey));
        }
    }

    protected static class TagAppenderWrapperImpl<A> implements TagProviderWrapper.TagAppenderWrapper<A> {
        private final TagAppender<A> appender;

        protected TagAppenderWrapperImpl(TagAppender<A> appender) {
            this.appender = appender;
        }

        @Override
        public TagProviderWrapper.TagAppenderWrapper<A> add(A object) {
            return new TagAppenderWrapperImpl<>(appender.add(object));
        }

        @SafeVarargs
        @Override
        public final TagProviderWrapper.TagAppenderWrapper<A> add(class_5321<A>... resourceKeys) {
            return new TagAppenderWrapperImpl<>(appender.add(resourceKeys));
        }

        @Override
        public TagProviderWrapper.TagAppenderWrapper<A> addOptional(class_2960 resourceLocation) {
            return new TagAppenderWrapperImpl<>(appender.addOptional(resourceLocation));
        }

        @Override
        public TagProviderWrapper.TagAppenderWrapper<A> addTag(class_6862<A> tagKey) {
            return new TagAppenderWrapperImpl<>(appender.addTag(tagKey));
        }

        @Override
        public TagProviderWrapper.TagAppenderWrapper<A> addOptionalTag(class_2960 resourceLocation) {
            return new TagAppenderWrapperImpl<>(appender.addOptionalTag(resourceLocation));
        }

        @SafeVarargs
        @Override
        public final TagProviderWrapper.TagAppenderWrapper<A> add(A... objects) {
            return new TagAppenderWrapperImpl<>(appender.add(objects));
        }
    }
}
