/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.data.provider;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.DevToolProviderWrapper;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNDataUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_7403;

public abstract class InputCopyProviderWrapper
extends DevToolProviderWrapper {
    public InputCopyProviderWrapper(CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(crossDataGeneratorAccess);
    }

    public abstract boolean isCopy(Path var1, Path var2);

    @Override
    public void run(class_7403 cachedOutput) throws IOException {
        ArrayList tasks = new ArrayList();
        Path outPath = this.getGenerator().method_10313();
        Collection<Path> inPaths = this.getCrossGeneratorAccess().getResourceInputFolders();
        for (Path path : inPaths) {
            Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);
            try {
                walk.forEach(tp -> {
                    if (this.isCopy(path, (Path)tp)) {
                        tasks.add(CompletableFuture.supplyAsync(() -> this.task(outPath, path, (Path)tp), class_156.method_18349()));
                    }
                });
            }
            finally {
                if (walk == null) continue;
                walk.close();
            }
        }
        for (CompletableFuture task : tasks) {
            try {
                TaskResult tr = (TaskResult)task.get();
                cachedOutput.method_43346(tr.path, tr.data, tr.hash);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private TaskResult task(Path outPath, Path inPath, Path path) {
        HashCode hashCode;
        byte[] bs;
        Path rp = inPath.relativize(path);
        Path op = outPath.resolve(rp);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
             BufferedInputStream stream = new BufferedInputStream(new FileInputStream(path.toFile()));){
            FNDataUtil.i2o(stream, (OutputStream)hashingOutputStream);
            bs = byteArrayOutputStream.toByteArray();
            hashCode = hashingOutputStream.hash();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new TaskResult(op, bs, hashCode);
    }

    @Override
    public String getName() {
        return "Input copy";
    }

    private record TaskResult(Path path, byte[] data, HashCode hash) {
    }
}

