/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.fabric.data;

import com.google.common.collect.ImmutableList;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.DataGeneratorType;
import dev.felnull.otyacraftengine.data.provider.BlockLootTableProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.BlockTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.DevToolProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.ItemTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.PoiTypeTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.RecipeProviderWrapper;
import dev.felnull.otyacraftengine.fabric.data.provider.WrappedFabricBlockLootTableProvider;
import dev.felnull.otyacraftengine.fabric.data.provider.WrappedFabricBlockTagProvider;
import dev.felnull.otyacraftengine.fabric.data.provider.WrappedFabricDevToolProvider;
import dev.felnull.otyacraftengine.fabric.data.provider.WrappedFabricItemTagProvider;
import dev.felnull.otyacraftengine.fabric.data.provider.WrappedFabricPoiTypeTagProvider;
import dev.felnull.otyacraftengine.fabric.data.provider.WrappedFabricRecipeProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2446;
import net.minecraft.class_2474;
import net.minecraft.class_4158;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class CrossDataGeneratorAccessImpl
implements CrossDataGeneratorAccess {
    private final List<Path> resourceInputFolders = new ArrayList<Path>();
    private final FabricDataGenerator fabricDataGenerator;

    protected CrossDataGeneratorAccessImpl(FabricDataGenerator fabricDataGenerator) {
        this.fabricDataGenerator = fabricDataGenerator;
    }

    @Override
    @NotNull
    public class_2403 getVanillaGenerator() {
        return this.fabricDataGenerator;
    }

    @Override
    public void addProvider(@NotNull DataGeneratorType dataGeneratorType, @NotNull class_2405 dataProvider) {
        this.fabricDataGenerator.addProvider(dataProvider);
    }

    @Override
    public Mod getMod() {
        return Platform.getMod((String)this.fabricDataGenerator.getModId());
    }

    @Override
    public class_2446 createRecipeProvider(RecipeProviderWrapper recipeProviderWrapper) {
        return new WrappedFabricRecipeProvider(this.fabricDataGenerator, recipeProviderWrapper);
    }

    @Override
    public class_2474<class_1792> createItemTagProvider(ItemTagProviderWrapper itemTagProviderWrapper, @NotNull BlockTagProviderWrapper blockTagProviderWrapper) {
        class_2474<class_2248> blockTagsProvider = blockTagProviderWrapper.getProvider();
        if (!(blockTagsProvider instanceof FabricTagProvider.BlockTagProvider)) {
            throw new IllegalArgumentException("Not FabricTagProvider.BlockTagProvider");
        }
        FabricTagProvider.BlockTagProvider blockTagProvider = (FabricTagProvider.BlockTagProvider)blockTagsProvider;
        return new WrappedFabricItemTagProvider(this.fabricDataGenerator, blockTagProvider, itemTagProviderWrapper);
    }

    @Override
    public class_2474<class_2248> createBlockTagProvider(BlockTagProviderWrapper blockTagProviderWrapper) {
        return new WrappedFabricBlockTagProvider(this.fabricDataGenerator, blockTagProviderWrapper);
    }

    @Override
    public class_2474<class_4158> createPoiTypeTagProvider(PoiTypeTagProviderWrapper poiTypeTagProviderWrapper) {
        return new WrappedFabricPoiTypeTagProvider(this.fabricDataGenerator, poiTypeTagProviderWrapper);
    }

    @Override
    public class_2405 createDevToolProvider(DevToolProviderWrapper devToolProviderWrapper) {
        return new WrappedFabricDevToolProvider(devToolProviderWrapper);
    }

    @Override
    public class_2405 createBlockLootTableProvider(BlockLootTableProviderWrapper blockLootTableProviderWrapper) {
        return new WrappedFabricBlockLootTableProvider(this.fabricDataGenerator, blockLootTableProviderWrapper);
    }

    @Override
    public boolean isInclude(DataGeneratorType type) {
        return true;
    }

    @Override
    public Collection<Path> getResourceInputFolders() {
        return ImmutableList.copyOf(this.resourceInputFolders);
    }

    @Override
    public void addResourceInputFolders(Path path) {
        this.resourceInputFolders.add(path);
    }
}

