package dev.felnull.otyacraftengine.fabric.client.model.impl;

import ;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.javagl.obj.Obj;
import de.javagl.obj.ObjReader;
import de.javagl.obj.ObjUtils;
import dev.felnull.otyacraftengine.fabric.client.model.OBJLoader;
import dev.felnull.otyacraftengine.fabric.client.model.OBJOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_804;
import net.minecraft.class_809;

public class OBJLoaderImpl implements OBJLoader {
    public static OBJLoader INSTANCE = new OBJLoaderImpl();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_809.class, new class_809.class_810()).registerTypeAdapter(class_804.class, new class_804.class_805()).create();
    private static final String LOADER_ID = "forge:obj";

    @Override
    public @Nullable class_1100 loadModel(@NotNull class_3300 resourceManager, @NotNull class_2960 location) throws IOException {
        class_2960 modelPath = new class_2960(location.method_12836(), location.method_12832() + ".json");
        Optional<JsonElement> loader = getRootElement(resourceManager, modelPath, "loader");
        return loader.map(elm -> {
            if (elm.isJsonPrimitive() && elm.getAsJsonPrimitive().isString() && LOADER_ID.equals(elm.getAsString())) {
                try {
                    Optional<JsonElement> model = getRootElement(resourceManager, modelPath, "model");
                    return model.map(mname -> {
                        if (mname.isJsonPrimitive() && mname.getAsJsonPrimitive().isString()) {
                            try {
                                Optional<JsonElement> display = getRootElement(resourceManager, modelPath, "display");
                                var option = OBJOption.of(str -> {
                                    try {
                                        return getRootElement(resourceManager, modelPath, str);
                                    } catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                });
                                return loadModel(resourceManager, new class_2960(mname.getAsString()), GSON.fromJson(display.orElseGet(JsonObject::new), class_809.class), option);
                            } catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return null;
                    }).orElse(null);
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }).orElse(null);
    }

    @Override
    public @Nullable class_1100 loadModel(@NotNull class_3300 resourceManager, @NotNull class_2960 location, @NotNull class_809 transforms, @NotNull OBJOption option) throws IOException {
        return resourceManager.method_14486(location).map(res -> {
            try (InputStream stream = res.method_14482(); Reader reader = new InputStreamReader(stream, StandardCharsets.UTF_8)) {
                var obj = ObjUtils.convertToRenderable(ObjReader.read(reader));
                return new OBJUnbakedModelModel(obj, loadMTL(resourceManager, location, obj.getMtlFileNames()), transforms, option);
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).orElse(null);
    }

    private Map<String, OBJMtl> loadMTL(class_3300 resourceManager, class_2960 modelLocation, List<String> mtlNames) throws IOException {
        Map<String, OBJMtl> mtls = new LinkedHashMap<>();
        for (String name : mtlNames) {
            var pths = modelLocation.method_12832().split("/");
            pths[pths.length - 1] = name;
            var pth = String.join("/", pths);
            class_2960 resourceId = new class_2960(modelLocation.method_12836(), pth);
            resourceManager.method_14486(resourceId).ifPresent(res -> {
                try (BufferedReader reader = res.method_43039()) {
                    OBJMtlReader.read(reader).forEach(mtl -> mtls.put(mtl.getName(), mtl));
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return mtls;
    }

    private Optional<JsonElement> getRootElement(class_3300 resourceManager, class_2960 modelPath, String name) throws IOException {
        while (modelPath != null) {
            var res = resourceManager.method_14486(modelPath);

            if (res.isEmpty()) return Optional.empty();

            try (InputStream stream = res.get().method_14482(); InputStreamReader reader = new InputStreamReader(stream)) {
                var rawModel = class_3518.method_15255(reader);

                if (rawModel.has(name)) return Optional.ofNullable(rawModel.get(name));

                if (rawModel.has("parent")) {
                    var modelId = new class_2960(rawModel.get("parent").getAsString());
                    modelPath = new class_2960(modelId.method_12836(), "models/" + modelId.method_12832() + ".json");
                } else {
                    modelPath = null;
                }
            }
        }
        return Optional.empty();
    }
}
