package dev.felnull.otyacraftengine.fabric.data.provider;

import dev.felnull.otyacraftengine.data.provider.ItemTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.TagProviderWrapper;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;

public class WrappedFabricItemTagProvider extends FabricTagProvider.ItemTagProvider {
    private final ItemTagProviderWrapper tagProviderWrapper;

    public WrappedFabricItemTagProvider(FabricDataGenerator dataGenerator, @NotNull BlockTagProvider blockTagProvider, ItemTagProviderWrapper tagProviderWrapper) {
        super(dataGenerator, blockTagProvider);
        this.tagProviderWrapper = tagProviderWrapper;
    }

    @Override
    protected void generateTags() {
        this.tagProviderWrapper.generateTag(new ItemTagProviderAccessImpl());
    }

    private class ItemTagProviderAccessImpl implements ItemTagProviderWrapper.ItemTagProviderAccess {
        @Override
        public void copy(class_6862<class_2248> blockTag, class_6862<class_1792> itemTag) {
            WrappedFabricItemTagProvider.this.copy(blockTag, itemTag);
        }

        @Override
        public TagProviderWrapper.TagAppenderWrapper<class_1792> tag(class_6862<class_1792> tagKey) {
            return new WrappedFabricTagProvider.TagAppenderWrapperImpl<>(WrappedFabricItemTagProvider.this.method_10512(tagKey));
        }
    }
}
