package dev.felnull.otyacraftengine.server.event;

import dev.architectury.event.CompoundEventResult;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_60;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class OEServerEventHooks {
    public static void onLootTableModify(class_60 lootManager, class_2960 id, LootTableEvent.LootTableModify modifyAccess) {
        LootTableEvent.LOOT_TABLE_MODIFY.invoker().lootTableModify(lootManager, id, modifyAccess);
    }

    public static class_52 onLootTableReplace(class_60 lootManager, class_2960 id, class_52 original) {
        var ret = LootTableEvent.LOOT_TABLE_REPLACE.invoker().lootTableReplace(lootManager, id, original);
        return ret.object();
    }

    public static void onServerSaving(@NotNull MinecraftServer server) {
        ServerEvent.SERVER_SAVING.invoker().stateChanged(server);
    }
}
