/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.util;

import dev.felnull.otyacraftengine.data.ITAGSerializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;

public class OENbtUtil {
    public static CompoundTag writeUUIDList(CompoundTag tag, String name, List<UUID> uuids) {
        return OENbtUtil.writeList(tag, name, uuids, NbtUtils::m_129226_);
    }

    public static <T> CompoundTag writeList(CompoundTag tag, String name, List<T> list, Function<T, Tag> writer) {
        ListTag listTag = new ListTag();
        list.forEach(n -> listTag.add((Object)((Tag)writer.apply(n))));
        tag.m_128365_(name, (Tag)listTag);
        return tag;
    }

    public static void readUUIDList(CompoundTag tag, String name, List<UUID> uuids) {
        OENbtUtil.readList(tag, name, uuids, NbtUtils::m_129233_, 11);
    }

    public static <T> void readList(CompoundTag tag, String name, List<T> list, Function<Tag, T> reader, int num) {
        list.clear();
        ListTag listTag = tag.m_128437_(name, num);
        for (Tag lstag : listTag) {
            list.add(reader.apply(lstag));
        }
    }

    public static <T> void readList(CompoundTag tag, String name, List<T> list, Function<Tag, T> reader) {
        OENbtUtil.readList(tag, name, list, reader, 10);
    }

    public static <T, M> CompoundTag writeMap(CompoundTag tag, String name, Map<T, M> map, Function<T, Tag> writerKey, Function<M, Tag> writerEntry) {
        Function<Map.Entry, Tag> writer = n -> {
            CompoundTag it = new CompoundTag();
            it.m_128365_("K", (Tag)writerKey.apply(n.getKey()));
            it.m_128365_("E", (Tag)writerEntry.apply(n.getValue()));
            return it;
        };
        return OENbtUtil.writeList(tag, name, new ArrayList<Map.Entry<T, M>>(map.entrySet()), writer);
    }

    public static <T, M> void readMap(CompoundTag tag, String name, Map<T, M> map, Function<Tag, T> readerKey, Function<Tag, M> readerEntry, int num) {
        ArrayList entries = new ArrayList();
        Function<Tag, Map.Entry> reader = n -> {
            CompoundTag it = (CompoundTag)n;
            return new AbstractMap.SimpleEntry(readerKey.apply(it.m_128423_("K")), readerEntry.apply(it.m_128423_("E")));
        };
        OENbtUtil.readList(tag, name, entries, reader, num);
        map.clear();
        entries.forEach(n -> map.put(n.getKey(), n.getValue()));
    }

    public static <T extends ITAGSerializable> CompoundTag writeSerializable(CompoundTag tag, String name, T serializable) {
        tag.m_128365_(name, (Tag)serializable.save(new CompoundTag()));
        return tag;
    }

    public static <T extends ITAGSerializable> T readSerializable(CompoundTag tag, String name, T serializable) {
        serializable.load(tag.m_128469_(name));
        return serializable;
    }
}

