/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.io;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.function.Consumer;

public class FileWatcher
extends Thread {
    private final Path path;
    private final Consumer<WatchEvent<?>> listener;
    private final WatchService watchService;

    public FileWatcher(Path path, Consumer<WatchEvent<?>> listener, WatchEvent.Kind<?> ... events) throws IOException {
        this.path = path.toAbsolutePath();
        this.listener = listener;
        this.watchService = FileSystems.getDefault().newWatchService();
        this.path.getParent().register(this.watchService, events);
        this.setName(path + " watcher");
    }

    @Override
    public void run() {
        while (this.isAlive()) {
            try {
                WatchKey take = this.watchService.take();
                for (WatchEvent<?> pollEvent : take.pollEvents()) {
                    if (!this.path.getFileName().equals(pollEvent.context())) continue;
                    this.listener.accept(pollEvent);
                }
                take.reset();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

