/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.networking;

import dev.architectury.networking.NetworkManager;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.handler.ClientMessageHandler;
import dev.felnull.otyacraftengine.handler.ServerMessageHandler;
import dev.felnull.otyacraftengine.networking.PacketMessage;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class OEPackets {
    public static final ResourceLocation TEST = new ResourceLocation("otyacraftengine", "test");
    public static final ResourceLocation BLOCK_ENTITY_SYNC = new ResourceLocation("otyacraftengine", "block_entity_sync");
    public static final ResourceLocation BLOCK_ENTITY_INSTRUCTION = new ResourceLocation("otyacraftengine", "block_entity_instruction");

    public static void init() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)BLOCK_ENTITY_INSTRUCTION, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onBlockEntityInstructionMessage(new BlockEntityInstructionMessage(friendlyByteBuf), packetContext));
    }

    public static void clientInit() {
        if (OtyacraftEngine.CONFIG.testMode) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)TEST, (friendlyByteBuf, packetContext) -> ClientMessageHandler.onTestMessage(new TestMessage(friendlyByteBuf), packetContext));
        }
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)BLOCK_ENTITY_SYNC, (friendlyByteBuf, packetContext) -> ClientMessageHandler.onBlockEntitySyncMessage(new BlockEntitySyncMessage(friendlyByteBuf), packetContext));
    }

    public static class BlockEntitySyncMessage
    implements PacketMessage {
        public final ResourceLocation dimension;
        public final BlockPos pos;
        public final ResourceLocation beName;
        public final CompoundTag syncedData;

        public BlockEntitySyncMessage(FriendlyByteBuf bf) {
            this(bf.m_130281_(), bf.m_130135_(), bf.m_130281_(), bf.m_130260_());
        }

        public BlockEntitySyncMessage(ResourceLocation dimension, BlockPos pos, ResourceLocation beName, CompoundTag syncedData) {
            this.dimension = dimension;
            this.pos = pos;
            this.beName = beName;
            this.syncedData = syncedData;
        }

        @Override
        public FriendlyByteBuf toFBB() {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130085_(this.dimension);
            buf.m_130064_(this.pos);
            buf.m_130085_(this.beName);
            buf.m_130079_(this.syncedData);
            return buf;
        }
    }

    public static class TestMessage
    implements PacketMessage {
        public final String str;
        public final int num;

        public TestMessage(FriendlyByteBuf bf) {
            this(bf.m_130277_(), bf.readInt());
        }

        public TestMessage(String str, int num) {
            this.str = str;
            this.num = num;
        }

        @Override
        public FriendlyByteBuf toFBB() {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130070_(this.str);
            buf.writeInt(this.num);
            return buf;
        }
    }

    public static class BlockEntityInstructionMessage
    implements PacketMessage {
        public final ResourceLocation dimension;
        public final BlockPos pos;
        public final ResourceLocation beName;
        public final String name;
        public final int num;
        public final CompoundTag data;

        public BlockEntityInstructionMessage(FriendlyByteBuf bf) {
            this(bf.m_130281_(), bf.m_130135_(), bf.m_130281_(), bf.m_130277_(), bf.readInt(), bf.m_130260_());
        }

        public BlockEntityInstructionMessage(ResourceLocation dimension, BlockPos pos, ResourceLocation beName, String name, int num, CompoundTag data) {
            this.dimension = dimension;
            this.pos = pos;
            this.beName = beName;
            this.name = name;
            this.num = num;
            this.data = data;
        }

        @Override
        public FriendlyByteBuf toFBB() {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130085_(this.dimension);
            buf.m_130064_(this.pos);
            buf.m_130085_(this.beName);
            buf.m_130070_(this.name);
            buf.writeInt(this.num);
            buf.m_130079_(this.data);
            return buf;
        }
    }
}

