package dev.felnull.otyacraftengine.client.gui.screen;

import dev.architectury.networking.NetworkManager;
import dev.felnull.otyacraftengine.blockentity.IInstructionBlockEntity;
import dev.felnull.otyacraftengine.networking.OEPackets;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;

import java.util.UUID;

public interface IInstructionBEScreen {
    UUID getInstructionID();

    public static void instructionBlockEntity(IInstructionBEScreen screen, BlockEntity blockEntity, String name, int num, CompoundTag data) {
        if (blockEntity instanceof IInstructionBlockEntity) {
            var mc = Minecraft.getInstance();
            NetworkManager.sendToServer(OEPackets.BLOCK_ENTITY_INSTRUCTION, new OEPackets.BlockEntityInstructionMessage(screen.getInstructionID(), mc.level.dimension().location(), blockEntity.getBlockPos(), Registry.BLOCK_ENTITY_TYPE.getKey(blockEntity.getType()), name, num, data).toFBB());
        }
    }

    void instruction(String name, int num, CompoundTag data);

    void instructionReturn(String name, int num, CompoundTag data);
}
