/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.util;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.InputConstants;
import dev.felnull.otyacraftengine.impl.client.OEClientExpectPlatform;
import dev.felnull.otyacraftengine.util.OELangUtil;
import dev.felnull.otyacraftengine.util.OEPlayerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.lwjgl.glfw.GLFW;

public class OEClientUtil {
    protected static final Map<String, GameProfile> PLAYER_PROFILES = new HashMap<String, GameProfile>();
    protected static final Map<UUID, String> PLAYER_NAME_UUIDS = new HashMap<UUID, String>();
    protected static final List<UUID> LOADING_PLAYER_NAMES = new ArrayList<UUID>();
    private static final Minecraft mc = Minecraft.m_91087_();

    public static GameProfile getClientPlayerProfile(String name) {
        if (PLAYER_PROFILES.containsKey(name)) {
            return PLAYER_PROFILES.get(name);
        }
        GameProfile gp = new GameProfile(null, name);
        PLAYER_PROFILES.put(name, gp);
        SkullBlockEntity.m_155738_((GameProfile)gp, n -> PLAYER_PROFILES.put(name, (GameProfile)n));
        return gp;
    }

    public static boolean isKeyInput(int keyCode) {
        if (keyCode < 0) {
            return false;
        }
        long winID = Minecraft.m_91087_().m_91268_().m_85439_();
        if (keyCode <= 7) {
            return GLFW.glfwGetMouseButton((long)winID, (int)keyCode) == 1;
        }
        return InputConstants.m_84830_((long)winID, (int)keyCode);
    }

    public static boolean isKeyInput(KeyMapping keyCode) {
        return OEClientUtil.isKeyInput(OEClientExpectPlatform.getKey(keyCode).m_84873_());
    }

    public static Optional<String> getPlayerNameByUUID(UUID uuid) {
        if (OEClientUtil.mc.f_91074_.f_108617_.m_104949_(uuid) != null) {
            return Optional.of(OEClientUtil.mc.f_91074_.f_108617_.m_104949_(uuid).m_105312_().getName());
        }
        if (PLAYER_NAME_UUIDS.containsKey(uuid)) {
            return Optional.of(PLAYER_NAME_UUIDS.get(uuid));
        }
        if (LOADING_PLAYER_NAMES.contains(uuid)) {
            return Optional.empty();
        }
        LOADING_PLAYER_NAMES.contains(uuid);
        OEPlayerUtil.getNameByUUIDAsync(uuid, n -> mc.m_18707_(() -> {
            PLAYER_NAME_UUIDS.put(uuid, n.orElse(null));
            LOADING_PLAYER_NAMES.remove(uuid);
        }));
        return Optional.empty();
    }

    public static LanguageInfo getLanguageByGoogleCode(String googleCode) {
        Optional<String> str = OELangUtil.getLangIdByGoogleCode(googleCode);
        if (str.isPresent()) {
            return mc.m_91102_().m_118976_(str.get());
        }
        for (LanguageInfo language : mc.m_91102_().m_118984_()) {
            if (!language.getCode().split("_")[0].equals(googleCode)) continue;
            return language;
        }
        return mc.m_91102_().m_118976_("en_us");
    }

    public static String getGoogleCodeByLanguage(LanguageInfo language) {
        Optional<String> lng = OELangUtil.getGoogleCodeByLangId(language.getCode());
        if (lng.isPresent()) {
            return lng.get();
        }
        String name = language.getCode().split("_")[0];
        for (String lang : OELangUtil.googleLangCodes) {
            if (!lang.equals(name)) continue;
            return lang;
        }
        return "en";
    }
}

