/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.util;

import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.math.FNComplex;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.math.FNVec2d;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.math.FNVec2i;
import java.util.function.Consumer;

public class FNMath {
    public static final double ABSOLUTE_ZERO_TEMP = (double)-273.15f;

    public static float toKelvinTemp(float celsius) {
        return celsius - -273.15f;
    }

    public static float toCelsiusTemp(float kelvin) {
        return kelvin + -273.15f;
    }

    public static int toKelvinTemp(int celsius) {
        return celsius - -273;
    }

    public static int toCelsiusTemp(int kelvin) {
        return kelvin + -273;
    }

    public static long toKelvinTemp(long celsius) {
        return celsius - -273L;
    }

    public static long toCelsiusTemp(long kelvin) {
        return kelvin + -273L;
    }

    public static double toKelvinTemp(double celsius) {
        return celsius - (double)-273.15f;
    }

    public static double toCelsiusTemp(double kelvin) {
        return kelvin + (double)-273.15f;
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(Math.min(value, max), min);
    }

    public static long clamp(long value, long min, long max) {
        return Math.max(Math.min(value, max), min);
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(Math.min(value, max), min);
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(Math.min(value, max), min);
    }

    public static boolean mandelbrot(double x, double y, int num) {
        return FNMath.mandelbrot(new FNComplex(x, y), num);
    }

    public static boolean mandelbrot(FNComplex complex, int num) {
        return complex.mandelbrot(num) >= num;
    }

    public static void generateMandelbrotSet(int width, int height, double posX, double posY, double zoom, int num, Consumer<FNVec2i> pos) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double xp = (-((double)width) / 2.0 + (double)x + posX) / (double)width;
                double yp = (-((double)height) / 2.0 + (double)y + posY) / (double)height;
                if (!FNMath.mandelbrot(xp * (4.0 / zoom), yp * (4.0 / zoom), num)) continue;
                pos.accept(new FNVec2i(x, y));
            }
        }
    }

    public static void generateColorMandelbrot(int width, int height, double posX, double posY, double zoom, int max, Consumer<PosColorEntry> pos) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double xp = (-((double)width) / 2.0 + (double)x + posX) / (double)width;
                double yp = (-((double)height) / 2.0 + (double)y + posY) / (double)height;
                pos.accept(new PosColorEntry(new FNVec2i(x, y), new FNComplex(xp * (4.0 / zoom), yp * (4.0 / zoom)).mandelbrot(max)));
            }
        }
    }

    public static FNVec2d scale(double w, double h) {
        if (w > h) {
            return new FNVec2d(1.0, h / w);
        }
        return new FNVec2d(w / h, 1.0);
    }

    public static class PosColorEntry {
        private final FNVec2i pos;
        private final int color;

        protected PosColorEntry(FNVec2i pos, int color) {
            this.pos = pos;
            this.color = color;
        }

        public FNVec2i getPos() {
            return this.pos;
        }

        public int getColor() {
            return this.color;
        }
    }
}

