/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import dev.felnull.otyacraftengine.client.util.OETextureUtil;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNColorUtil;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OERenderUtil {
    private static final Minecraft mc = Minecraft.m_91087_();
    public static final float MIN_BREADTH = 0.001f;

    public static void renderCenterTextSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, Component text, float x, float y, float z, float size, float textX, float textY, int color, int combinedLightIn) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, (double)z);
        poseStack.m_85841_(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        Font font = OERenderUtil.mc.f_91062_;
        float f = (float)(-OERenderUtil.mc.f_91062_.m_92852_((FormattedText)text)) / 2.0f + textX;
        Objects.requireNonNull(OERenderUtil.mc.f_91062_);
        font.m_92841_(text, f, (float)(-9) + textY, color, false, poseStack.m_85850_().m_85861_(), multiBufferSource, false, 0, combinedLightIn);
        poseStack.m_85849_();
    }

    public static void renderCenterTextSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, Component text, float x, float y, float z, float size, float textX, float textY, int combinedLightIn) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, (double)z);
        poseStack.m_85841_(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        Font font = OERenderUtil.mc.f_91062_;
        float f = (float)(-OERenderUtil.mc.f_91062_.m_92852_((FormattedText)text)) / 2.0f + textX;
        Objects.requireNonNull(OERenderUtil.mc.f_91062_);
        font.m_92841_(text, f, (float)(-9) + textY, 0, false, poseStack.m_85850_().m_85861_(), multiBufferSource, false, 0, combinedLightIn);
        poseStack.m_85849_();
    }

    public static void renderTextSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, Component text, float x, float y, float z, float size, float textX, float textY, int color, int combinedLightIn) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, (double)z);
        poseStack.m_85841_(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        Font font = OERenderUtil.mc.f_91062_;
        Objects.requireNonNull(OERenderUtil.mc.f_91062_);
        font.m_92841_(text, textX, (float)(-9) + textY, color, false, poseStack.m_85850_().m_85861_(), multiBufferSource, false, 0, combinedLightIn);
        poseStack.m_85849_();
    }

    public static void renderTextSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, Component text, float x, float y, float z, float size, float textX, float textY, int combinedLightIn) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, (double)z);
        poseStack.m_85841_(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        Font font = OERenderUtil.mc.f_91062_;
        Objects.requireNonNull(OERenderUtil.mc.f_91062_);
        font.m_92841_(text, textX, (float)(-9) + textY, 0, false, poseStack.m_85850_().m_85861_(), multiBufferSource, false, 0, combinedLightIn);
        poseStack.m_85849_();
    }

    public static void drawFixedWidthText(PoseStack poseStack, Component text, float x, float y, int color, float width) {
        int size = OERenderUtil.mc.f_91062_.m_92852_((FormattedText)text);
        poseStack.m_85836_();
        if ((float)size > width) {
            float scale = width / (float)size;
            x /= scale;
            y /= scale;
            OERenderUtil.poseScaleAll(poseStack, scale);
        }
        OERenderUtil.mc.f_91062_.m_92889_(poseStack, text, x, y, color);
        poseStack.m_85849_();
    }

    public static void drawFixedWidthText(PoseStack poseStack, String text, float x, float y, int color, float width) {
        int size = OERenderUtil.mc.f_91062_.m_92895_(text);
        poseStack.m_85836_();
        if ((float)size > width) {
            float scale = width / (float)size;
            x /= scale;
            y /= scale;
            OERenderUtil.poseScaleAll(poseStack, scale);
        }
        OERenderUtil.mc.f_91062_.m_92883_(poseStack, text, x, y, color);
        poseStack.m_85849_();
    }

    public static void drawCenterText(PoseStack poseStack, Component text, float x, float y, int color) {
        OERenderUtil.mc.f_91062_.m_92889_(poseStack, text, x - (float)OERenderUtil.mc.f_91062_.m_92852_((FormattedText)text) / 2.0f, y, color);
    }

    public static void drawCenterText(PoseStack poseStack, String str, float x, float y, int color) {
        OERenderUtil.mc.f_91062_.m_92883_(poseStack, str, x - (float)OERenderUtil.mc.f_91062_.m_92895_(str) / 2.0f, y, color);
    }

    public static void drawPlayerFace(PoseStack poseStack, UUID uuid, float x, float y) {
        OERenderUtil.drawPlayerFace(poseStack, uuid, x, y, 8.0f);
    }

    public static void drawPlayerFace(PoseStack poseStack, UUID uuid, float x, float y, float size) {
        poseStack.m_85836_();
        float sc = size / 8.0f;
        ResourceLocation plskin = OETextureUtil.getPlayerSkinTexture(uuid);
        OERenderUtil.drawTexture(plskin, poseStack, x, y, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        OERenderUtil.drawTexture(plskin, poseStack, x, y, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        poseStack.m_85849_();
    }

    public static void drawPlayerFace(PoseStack poseStack, String name, float x, float y) {
        OERenderUtil.drawPlayerFace(poseStack, name, x, y, 8.0f);
    }

    public static void drawPlayerFace(PoseStack poseStack, String name, float x, float y, float size) {
        poseStack.m_85836_();
        float sc = size / 8.0f;
        ResourceLocation plskin = OETextureUtil.getPlayerSkinTexture(name);
        OERenderUtil.drawTexture(plskin, poseStack, x, y, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        OERenderUtil.drawTexture(plskin, poseStack, x, y, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        poseStack.m_85849_();
    }

    public static void drawTexture(ResourceLocation location, PoseStack poseStack, float x, float y, float textureStartX, float textureStartY, float textureFinishWidth, float textureFinishHeight) {
        OERenderUtil.drawTexture(location, poseStack, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, 256.0f, 256.0f);
    }

    public static void drawTexture(ResourceLocation location, PoseStack poseStack, float x, float y, float textureStartX, float textureStartY, float textureFinishWidth, float textureFinishHeight, float textureSizeX, float textureSizeY) {
        poseStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)location);
        OERenderUtil.fBlit(poseStack, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, textureSizeX, textureSizeY);
        poseStack.m_85849_();
    }

    public static void drawColorTexture(ResourceLocation location, PoseStack poseStack, float x, float y, float textureStartX, float textureStartY, float textureFinishWidth, float textureFinishHeight, int color) {
        OERenderUtil.drawColorTexture(location, poseStack, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, 256.0f, 256.0f, color);
    }

    public static void drawColorTexture(ResourceLocation location, PoseStack poseStack, float x, float y, float textureStartX, float textureStartY, float textureFinishWidth, float textureFinishHeight, float textureSizeX, float textureSizeY, int color) {
        float r = (float)FNColorUtil.getRed(color) / 255.0f;
        float g = (float)FNColorUtil.getGreen(color) / 255.0f;
        float b = (float)FNColorUtil.getBlue(color) / 255.0f;
        float a = (float)FNColorUtil.getAlpha(color) / 255.0f;
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
        RenderSystem.m_157456_((int)0, (ResourceLocation)location);
        OERenderUtil.fBlit(poseStack, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, textureSizeX, textureSizeY);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        poseStack.m_85849_();
    }

    private static void fBlit(PoseStack poseStack, float ix, float iy, float tsx, float tsy, float tw, float th, float tssx, float tssy) {
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        float x = ix;
        float y = ix + tw;
        float w = iy;
        float h = iy + th;
        float u1 = tsx / tssx;
        float u2 = (tsx + tw) / tssx;
        float v1 = tsy / tssy;
        float v2 = (tsy + th) / tssy;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix4f, x, h, 0.0f).m_7421_(u1, v2).m_5752_();
        bufferBuilder.m_85982_(matrix4f, y, h, 0.0f).m_7421_(u2, v2).m_5752_();
        bufferBuilder.m_85982_(matrix4f, y, w, 0.0f).m_7421_(u2, v1).m_5752_();
        bufferBuilder.m_85982_(matrix4f, x, w, 0.0f).m_7421_(u1, v1).m_5752_();
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
    }

    public static void poseTrans16(PoseStack poseStack, double x, double y, double z) {
        float pix = 0.0625f;
        poseStack.m_85837_((double)pix * x, (double)pix * y, (double)pix * z);
    }

    public static void poseScaleAll(PoseStack poseStack, float scale) {
        poseStack.m_85841_(scale, scale, scale);
    }

    public static void poseRotateAll(PoseStack poseStack, float x, float y, float z) {
        OERenderUtil.poseRotateX(poseStack, x);
        OERenderUtil.poseRotateY(poseStack, y);
        OERenderUtil.poseRotateZ(poseStack, z);
    }

    public static void poseRotateX(PoseStack poseStack, float angle) {
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(angle));
    }

    public static void poseRotateY(PoseStack poseStack, float angle) {
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(angle));
    }

    public static void poseRotateZ(PoseStack poseStack, float angle) {
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(angle));
    }

    public static void poseRotateHorizontalState(PoseStack poseStack, BlockState state, int roted) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        OERenderUtil.poseRotateDirection(poseStack, direction, roted);
    }

    public static void poseRotateDirection(PoseStack poseStack, Direction direction, int roted) {
        for (int i = 0; i < roted; ++i) {
            direction = direction.m_122427_();
        }
        if (direction == Direction.WEST) {
            OERenderUtil.poseRotateY(poseStack, 180.0f);
            poseStack.m_85837_(-1.0, 0.0, -1.0);
        } else if (direction == Direction.NORTH) {
            OERenderUtil.poseRotateY(poseStack, 90.0f);
            poseStack.m_85837_(-1.0, 0.0, 0.0);
        } else if (direction == Direction.SOUTH) {
            OERenderUtil.poseRotateY(poseStack, 270.0f);
            poseStack.m_85837_(0.0, 0.0, -1.0);
        }
    }

    public static void renderPlayerFaceSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, UUID uuid, float x, float y, float z, float pitch, float yaw, float roll, float size, int combinedLightIn, int combinedOverlayIn) {
        float sc = size / 8.0f;
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, size, size, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x, y, z + 1.0E-5f, pitch, yaw, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
    }

    public static void renderPlayerFaceSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, String name, float x, float y, float z, float pitch, float yaw, float roll, float size, int combinedLightIn, int combinedOverlayIn) {
        float sc = size / 8.0f;
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, size, size, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x, y, z + 1.0E-5f, pitch, yaw, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
    }

    public static void renderPlayerFaceSpriteSides(PoseStack poseStack, MultiBufferSource multiBufferSource, UUID uuid, float x, float y, float z, float pitch, float yaw, float roll, float size, int combinedLightIn, int combinedOverlayIn) {
        float sc = size / 8.0f;
        OERenderUtil.renderTextureSpriteSides(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, size, size, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x, y, z + 1.0E-5f, pitch, yaw, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x + 1.0f, y, z - 2.0E-5f, pitch, yaw + 180.0f, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
    }

    public static void renderPlayerFaceSpriteSides(PoseStack poseStack, MultiBufferSource multiBufferSource, String name, float x, float y, float z, float pitch, float yaw, float roll, float size, int combinedLightIn, int combinedOverlayIn) {
        float sc = size / 8.0f;
        OERenderUtil.renderTextureSpriteSides(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, size, size, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x, y, z + 1.0E-5f, pitch, yaw, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x + 1.0f, y, z - 2.0E-5f, pitch, yaw + 180.0f, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
    }

    public static void renderTextureSprite(ResourceLocation location, PoseStack poseStack, MultiBufferSource multiBufferSource, float x, float y, float z, float pitch, float yaw, float roll, float w, float h, float texStartX, float texStartY, float texFinishX, float texFinishY, float texSizeW, float texSizeH, int combinedLightIn, int combinedOverlayIn) {
        OERenderUtil.renderColorTextureSprite(location, poseStack, multiBufferSource, x, y, z, 1.0f, 1.0f, 1.0f, 1.0f, pitch, yaw, roll, w, h, texStartX, texStartY, texFinishX, texFinishY, texSizeW, texSizeH, combinedLightIn, combinedOverlayIn);
    }

    public static void renderColorTextureSprite(ResourceLocation location, PoseStack poseStack, MultiBufferSource multiBufferSource, float x, float y, float z, float r, float g, float b, float a, float pitch, float yaw, float roll, float w, float h, float texStartX, float texStartY, float texFinishX, float texFinishY, float texSizeW, float texSizeH, int combinedLightIn, int combinedOverlayIn) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, (double)z);
        OERenderUtil.poseRotateY(poseStack, yaw);
        OERenderUtil.poseRotateX(poseStack, pitch);
        OERenderUtil.poseRotateZ(poseStack, roll);
        VertexConsumer vc = multiBufferSource.m_6299_(RenderType.m_110497_((ResourceLocation)location));
        float wst = texStartX / texSizeW;
        float wft = texFinishX / texSizeW + wst;
        float hst = texStartY / texSizeH;
        float hft = texFinishY / texSizeH + hst;
        PoseStack.Pose pose = poseStack.m_85850_();
        OERenderUtil.vertex(vc, pose, 0.0f, 0.0f, 0.0f, wst, hft, r, g, b, a, combinedOverlayIn, combinedLightIn);
        OERenderUtil.vertex(vc, pose, w, 0.0f, 0.0f, wft, hft, r, g, b, a, combinedOverlayIn, combinedLightIn);
        OERenderUtil.vertex(vc, pose, w, h, 0.0f, wft, hst, r, g, b, a, combinedOverlayIn, combinedLightIn);
        OERenderUtil.vertex(vc, pose, 0.0f, h, 0.0f, wst, hst, r, g, b, a, combinedOverlayIn, combinedLightIn);
        poseStack.m_85849_();
    }

    public static void renderTextureSpriteSides(ResourceLocation location, PoseStack poseStack, MultiBufferSource multiBufferSource, float x, float y, float z, float pitch, float yaw, float roll, float w, float h, float texStartX, float texStartY, float texFinishX, float texFinishY, float texSizeW, float texSizeH, int combinedLightIn, int combinedOverlayIn) {
        OERenderUtil.renderTextureSprite(location, poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, w, h, texStartX, texStartY, texFinishX, texFinishY, texSizeW, texSizeH, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(location, poseStack, multiBufferSource, x + 1.0f, y, z - 1.0E-5f, pitch, yaw + 180.0f, roll, w, h, texStartX, texStartY, texFinishX, texFinishY, texSizeW, texSizeH, combinedLightIn, combinedOverlayIn);
    }

    private static void vertex(VertexConsumer builder, PoseStack.Pose pose, float x, float y, float z, float u, float v, float r, float g, float b, float a, int combinedOverlayIn, int combinedLightIn) {
        builder.m_85982_(pose.m_85861_(), x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_86008_(combinedOverlayIn).m_85969_(combinedLightIn).m_85977_(pose.m_85864_(), 0.0f, 0.0f, 0.0f).m_5752_();
    }

    public static BakedModel getModel(ModelResourceLocation location) {
        return mc.m_91304_().m_119422_(location);
    }

    public static BakedModel getBlockModel(BlockState state) {
        return mc.m_91304_().m_119430_().m_110893_(state);
    }

    public static void renderModel(PoseStack poseStack, VertexConsumer vertexConsumer, BakedModel bakedModel, int combinedLight, int combinedOverlay) {
        ModelBlockRenderer bmr = mc.m_91289_().m_110937_();
        bmr.m_111067_(poseStack.m_85850_(), vertexConsumer, null, bakedModel, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay);
    }

    public static void renderModel(PoseStack poseStack, VertexConsumer vertexConsumer, BakedModel bakedModel, int combinedLight, int combinedOverlay, int color) {
        ModelBlockRenderer bmr = mc.m_91289_().m_110937_();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        bmr.m_111067_(poseStack.m_85850_(), vertexConsumer, null, bakedModel, r, g, b, combinedLight, combinedOverlay);
    }
}

