/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.ArrayUtils;

public class OEVoxelShapeUtil {
    private static final Gson gson = new Gson();

    public static VoxelShape makeBox(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static VoxelShape makeBoxY90(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBox(z1, y1, 16.0 - x1, z2, y2, 16.0 - x2);
    }

    public static VoxelShape makeBoxY180(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBox(16.0 - x1, y1, 16.0 - z1, 16.0 - x2, y2, 16.0 - z2);
    }

    public static VoxelShape makeBoxY270(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBoxY180(z1, y1, 16.0 - x1, z2, y2, 16.0 - x2);
    }

    public static VoxelShape addBoxY0(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBox(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static VoxelShape addBoxY90(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBoxY90(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static VoxelShape addBoxY180(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBoxY180(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static VoxelShape addBoxY270(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBoxY270(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static VoxelShape uniteBox(VoxelShape ... shapes) {
        return Shapes.m_83124_((VoxelShape)shapes[0], (VoxelShape[])((VoxelShape[])ArrayUtils.remove((Object[])shapes, (int)0)));
    }

    public static VoxelShape moveBox(VoxelShape shape, double x, double y, double z) {
        Object[] shapes = new VoxelShape[]{};
        for (AABB aabb : shape.m_83299_()) {
            shapes = (VoxelShape[])ArrayUtils.add((Object[])shapes, (Object)Shapes.m_83064_((AABB)aabb.m_82386_(0.0625 * x, 0.0625 * y, 0.0625 * z)));
        }
        return OEVoxelShapeUtil.uniteBox((VoxelShape[])shapes);
    }

    public static VoxelShape rotateBoxY90(VoxelShape shape) {
        Object[] shapes = new VoxelShape[]{};
        for (AABB aabb : shape.m_83299_()) {
            shapes = (VoxelShape[])ArrayUtils.add((Object[])shapes, (Object)Shapes.m_83064_((AABB)new AABB(aabb.f_82290_, aabb.f_82289_, 1.0 - aabb.f_82288_, aabb.f_82293_, aabb.f_82292_, 1.0 - aabb.f_82291_)));
        }
        return OEVoxelShapeUtil.uniteBox((VoxelShape[])shapes);
    }

    public static VoxelShape rotateBoxY180(VoxelShape shape) {
        Object[] shapes = new VoxelShape[]{};
        for (AABB aabb : shape.m_83299_()) {
            shapes = (VoxelShape[])ArrayUtils.add((Object[])shapes, (Object)Shapes.m_83064_((AABB)new AABB(1.0 - aabb.f_82288_, aabb.f_82289_, 1.0 - aabb.f_82290_, 1.0 - aabb.f_82291_, aabb.f_82292_, 1.0 - aabb.f_82293_)));
        }
        return OEVoxelShapeUtil.uniteBox((VoxelShape[])shapes);
    }

    public static VoxelShape rotateBoxY270(VoxelShape shape) {
        Object[] shapes = new VoxelShape[]{};
        for (AABB aabb : OEVoxelShapeUtil.rotateBoxY180(shape).m_83299_()) {
            shapes = (VoxelShape[])ArrayUtils.add((Object[])shapes, (Object)Shapes.m_83064_((AABB)new AABB(aabb.f_82290_, aabb.f_82289_, 1.0 - aabb.f_82288_, aabb.f_82293_, aabb.f_82292_, 1.0 - aabb.f_82291_)));
        }
        return OEVoxelShapeUtil.uniteBox((VoxelShape[])shapes);
    }

    public static VoxelShape rotateBoxX90(VoxelShape shape) {
        Object[] shapes = new VoxelShape[]{};
        for (AABB aabb : shape.m_83299_()) {
            shapes = (VoxelShape[])ArrayUtils.add((Object[])shapes, (Object)Shapes.m_83064_((AABB)new AABB(aabb.f_82289_, aabb.f_82288_, aabb.f_82290_, aabb.f_82292_, aabb.f_82291_, aabb.f_82293_)));
        }
        return OEVoxelShapeUtil.uniteBox((VoxelShape[])shapes);
    }

    public static VoxelShape rotateBoxX180(VoxelShape shape) {
        Object[] shapes = new VoxelShape[]{};
        for (AABB aabb : shape.m_83299_()) {
            shapes = (VoxelShape[])ArrayUtils.add((Object[])shapes, (Object)Shapes.m_83064_((AABB)new AABB(1.0 - aabb.f_82288_, 1.0 - aabb.f_82289_, aabb.f_82290_, 1.0 - aabb.f_82291_, 1.0 - aabb.f_82292_, aabb.f_82293_)));
        }
        return OEVoxelShapeUtil.uniteBox((VoxelShape[])shapes);
    }

    public static VoxelShape rotateBoxX270(VoxelShape shape) {
        Object[] shapes = new VoxelShape[]{};
        for (AABB aabb : OEVoxelShapeUtil.rotateBoxY180(shape).m_83299_()) {
            shapes = (VoxelShape[])ArrayUtils.add((Object[])shapes, (Object)Shapes.m_83064_((AABB)new AABB(1.0 - aabb.f_82289_, aabb.f_82288_, aabb.f_82290_, 1.0 - aabb.f_82292_, aabb.f_82291_, aabb.f_82293_)));
        }
        return OEVoxelShapeUtil.uniteBox((VoxelShape[])shapes);
    }

    public static VoxelShape rotateBoxZ90(VoxelShape shape) {
        Object[] shapes = new VoxelShape[]{};
        for (AABB aabb : shape.m_83299_()) {
            shapes = (VoxelShape[])ArrayUtils.add((Object[])shapes, (Object)Shapes.m_83064_((AABB)new AABB(aabb.f_82288_, aabb.f_82290_, aabb.f_82289_, aabb.f_82291_, aabb.f_82293_, aabb.f_82292_)));
        }
        return OEVoxelShapeUtil.uniteBox((VoxelShape[])shapes);
    }

    public static VoxelShape rotateBoxZ180(VoxelShape shape) {
        Object[] shapes = new VoxelShape[]{};
        for (AABB aabb : shape.m_83299_()) {
            shapes = (VoxelShape[])ArrayUtils.add((Object[])shapes, (Object)Shapes.m_83064_((AABB)new AABB(aabb.f_82288_, 1.0 - aabb.f_82289_, 1.0 - aabb.f_82290_, aabb.f_82291_, 1.0 - aabb.f_82292_, 1.0 - aabb.f_82293_)));
        }
        return OEVoxelShapeUtil.uniteBox((VoxelShape[])shapes);
    }

    public static VoxelShape rotateBoxDirection(VoxelShape shape, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> OEVoxelShapeUtil.rotateBoxY180(shape);
            case Direction.EAST -> OEVoxelShapeUtil.rotateBoxY270(shape);
            case Direction.WEST -> OEVoxelShapeUtil.rotateBoxY90(shape);
            default -> shape;
        };
    }

    public static VoxelShape getShapeFromJson(JsonObject shapeJ) {
        VoxelShape[] shapes = null;
        for (JsonElement jshape : shapeJ.getAsJsonArray("shapes")) {
            JsonArray ja = jshape.getAsJsonArray();
            VoxelShape shape = OEVoxelShapeUtil.makeBox(ja.get(0).getAsDouble(), ja.get(1).getAsDouble(), ja.get(2).getAsDouble(), ja.get(3).getAsDouble(), ja.get(4).getAsDouble(), ja.get(5).getAsDouble());
            shapes = (VoxelShape[])ArrayUtils.add(shapes, (Object)shape);
        }
        return OEVoxelShapeUtil.uniteBox(shapes);
    }

    public static VoxelShape getShapeFromResource(ResourceLocation location) {
        InputStream stream = OEVoxelShapeUtil.class.getResourceAsStream("/data/" + location.m_135827_() + "/shape/" + location.m_135815_() + ".json");
        if (stream == null) {
            return OEVoxelShapeUtil.makeBox(16.0, 16.0, 16.0, 16.0, 16.0, 16.0);
        }
        return OEVoxelShapeUtil.getShapeFromJson((JsonObject)gson.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class));
    }
}

