/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.handler;

import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.platform.Platform;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.util.ClientUtilInit;
import dev.felnull.otyacraftengine.util.OEItemUtil;
import dev.felnull.otyacraftengine.util.OETagUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;

public class ClientHandler {
    public static void init() {
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(ClientHandler::onQuit);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(ClientHandler::onJoin);
        ClientTooltipEvent.ITEM.register(ClientHandler::onTooltip);
    }

    private static void onJoin(LocalPlayer localPlayer) {
        ClientUtilInit.clear();
    }

    private static void onQuit(LocalPlayer localPlayer) {
        ClientUtilInit.clear();
    }

    private static void onTooltip(ItemStack itemStack, List<Component> list, TooltipFlag tooltipFlag) {
        if (itemStack.m_41619_()) {
            return;
        }
        Item item = itemStack.m_41720_();
        if (OtyacraftEngine.CONFIG.showTagTooltip) {
            Set<ResourceLocation> itemTags = OETagUtil.getTags(item);
            Item item2 = item;
            if (item2 instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item2;
                Set<ResourceLocation> blockTags = OETagUtil.getTags(blockItem.m_40614_());
                HashSet<ResourceLocation> bothTags = new HashSet<ResourceLocation>();
                boolean firstItem = false;
                boolean firstBlock = false;
                for (ResourceLocation tag : itemTags) {
                    if (!blockTags.contains(tag)) {
                        if (!firstItem) {
                            list.add((Component)new TextComponent("Item tags").m_130940_(ChatFormatting.AQUA));
                            firstItem = true;
                        }
                        list.add((Component)new TextComponent(" - " + tag));
                        continue;
                    }
                    bothTags.add(tag);
                }
                Iterator<Object> iterator = blockTags.iterator();
                while (iterator.hasNext()) {
                    ResourceLocation blockTag = (ResourceLocation)iterator.next();
                    if (!itemTags.contains(blockTag)) {
                        if (!firstBlock) {
                            list.add((Component)new TextComponent("Block tags").m_130940_(ChatFormatting.AQUA));
                            firstBlock = true;
                        }
                        list.add((Component)new TextComponent(" - " + blockTag));
                        continue;
                    }
                    bothTags.add(blockTag);
                }
                if (!bothTags.isEmpty()) {
                    list.add((Component)new TextComponent("Both tags").m_130940_(ChatFormatting.AQUA));
                    for (ResourceLocation tag : bothTags) {
                        list.add((Component)new TextComponent(" - " + tag));
                    }
                }
            } else if (!itemTags.isEmpty()) {
                list.add((Component)new TextComponent("Item tags").m_130940_(ChatFormatting.AQUA));
                for (ResourceLocation tag : itemTags) {
                    list.add((Component)new TextComponent(" - " + tag));
                }
            }
            Set<EntityType<?>> entityTypes = ClientHandler.getEntityTypesByItem(itemStack);
            HashSet entityTypeTags = new HashSet();
            entityTypes.forEach(n -> entityTypeTags.addAll(OETagUtil.getTags(n)));
            if (!entityTypeTags.isEmpty()) {
                list.add((Component)new TextComponent("Entity tags").m_130940_(ChatFormatting.AQUA));
                for (ResourceLocation tag : entityTypeTags) {
                    list.add((Component)new TextComponent(" - " + tag));
                }
            }
        }
        if (OtyacraftEngine.CONFIG.showModNameTooltip) {
            ResourceLocation modid = Registry.f_122827_.m_7981_((Object)item);
            list.add((Component)new TextComponent(Platform.getMod((String)modid.m_135827_()).getName()).m_130940_(ChatFormatting.DARK_GREEN));
        }
    }

    private static Set<EntityType<?>> getEntityTypesByItem(ItemStack stack) {
        Item item = stack.m_41720_();
        Item item2 = item;
        if (item2 instanceof SpawnEggItem) {
            SpawnEggItem spawnEggItem = (SpawnEggItem)item2;
            return Set.of(spawnEggItem.m_43228_(stack.m_41783_()));
        }
        item2 = item;
        if (item2 instanceof MobBucketItem) {
            MobBucketItem mobBucketItem = (MobBucketItem)item2;
            return Set.of(OEItemUtil.getMobBucketEntity(mobBucketItem));
        }
        return Set.of();
    }
}

