/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.item;

import dev.felnull.otyacraftengine.item.location.IPlayerItemLocation;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemContainer
implements Container {
    private final ItemStack itemStack;
    private final IPlayerItemLocation location;
    private final NonNullList<ItemStack> items;
    private final String tagName;
    private final Function<Player, Boolean> valid;

    public ItemContainer(ItemStack itemStack, IPlayerItemLocation location, int size, String tagName, Function<Player, Boolean> valid) {
        this.itemStack = itemStack;
        this.items = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        this.location = location;
        ItemContainer.loadItemList(itemStack, this.items, tagName);
        this.tagName = tagName;
        this.valid = valid;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int i) {
        return (ItemStack)this.items.get(i);
    }

    public ItemStack m_7407_(int i, int j) {
        ItemStack ret = ContainerHelper.m_18969_(this.items, (int)i, (int)j);
        this.saveItems();
        return ret;
    }

    public ItemStack m_8016_(int i) {
        ItemStack ret = ContainerHelper.m_18966_(this.items, (int)i);
        this.saveItems();
        return ret;
    }

    public void m_6836_(int i, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(i);
        boolean flag = !stack.m_41619_() && stack.m_41656_(itemstack) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(i, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (flag) {
            this.m_6596_();
        }
    }

    public void m_6596_() {
        this.saveItems();
    }

    public boolean m_6542_(Player player) {
        return this.valid.apply(player) != false && this.location.getItem(player) == this.itemStack;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_5785_(Player player) {
        super.m_5785_(player);
        this.saveItems();
    }

    public IPlayerItemLocation getLocation() {
        return this.location;
    }

    public void saveItems() {
        ItemContainer.saveItemList(this.itemStack, this.items, this.tagName);
    }

    public static void loadItemList(ItemStack itemStack, NonNullList<ItemStack> items, String tagName) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            ContainerHelper.m_18980_((CompoundTag)tag.m_128469_(tagName), items);
        }
    }

    public static void saveItemList(ItemStack itemStack, NonNullList<ItemStack> items, String tagName) {
        CompoundTag tag = itemStack.m_41784_();
        if (!tag.m_128441_(tagName)) {
            tag.m_128365_(tagName, (Tag)new CompoundTag());
        }
        ContainerHelper.m_18973_((CompoundTag)tag.m_128469_(tagName), items);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

