/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.block.IIkisugiVoxelShape;
import dev.felnull.otyacraftengine.block.IkisugiVoxelShape;
import dev.felnull.otyacraftengine.block.RotateAngledAxis;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.ArrayUtils;

public class OEVoxelShapeUtil {
    private static final Gson gson = new Gson();

    public static VoxelShape makeBox(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static VoxelShape makeBoxY90(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBox(z1, y1, 16.0 - x1, z2, y2, 16.0 - x2);
    }

    public static VoxelShape makeBoxY180(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBox(16.0 - x1, y1, 16.0 - z1, 16.0 - x2, y2, 16.0 - z2);
    }

    public static VoxelShape makeBoxY270(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBoxY180(z1, y1, 16.0 - x1, z2, y2, 16.0 - x2);
    }

    public static VoxelShape addBoxY0(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBox(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static VoxelShape addBoxY90(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBoxY90(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static VoxelShape addBoxY180(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBoxY180(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static VoxelShape addBoxY270(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBoxY270(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static VoxelShape uniteBox(VoxelShape ... shapes) {
        VoxelShape shape = Shapes.m_83124_((VoxelShape)shapes[0], (VoxelShape[])((VoxelShape[])ArrayUtils.remove((Object[])shapes, (int)0)));
        return IkisugiVoxelShape.getInstance().unite(shape, shapes);
    }

    public static VoxelShape uniteBox(List<VoxelShape> shapes) {
        if (shapes.isEmpty()) {
            return Shapes.m_83040_();
        }
        ArrayList<VoxelShape> shapesCp = new ArrayList<VoxelShape>(shapes);
        VoxelShape voxelShape = (VoxelShape)shapesCp.remove(0);
        VoxelShape shape = shapesCp.stream().reduce(voxelShape, Shapes::m_83110_);
        return IkisugiVoxelShape.getInstance().unite(shape, shapes.stream().map(n -> (IIkisugiVoxelShape)n).toList());
    }

    public static VoxelShape moveBox(VoxelShape shape, double x, double y, double z) {
        Object[] shapes = new VoxelShape[]{};
        for (AABB aabb : shape.m_83299_()) {
            shapes = (VoxelShape[])ArrayUtils.add((Object[])shapes, (Object)Shapes.m_83064_((AABB)aabb.m_82386_(0.0625 * x, 0.0625 * y, 0.0625 * z)));
        }
        VoxelShape ushape = OEVoxelShapeUtil.uniteBox((VoxelShape[])shapes);
        return IkisugiVoxelShape.getInstance().move(ushape, (IIkisugiVoxelShape)shape, x, y, z);
    }

    public static VoxelShape rotateBox(VoxelShape shape, RotateAngledAxis angledAxis) {
        Object[] shapes = new VoxelShape[]{};
        for (AABB aabb : shape.m_83299_()) {
            shapes = (VoxelShape[])ArrayUtils.add((Object[])shapes, (Object)Shapes.m_83064_((AABB)angledAxis.convertAABB(aabb)));
        }
        VoxelShape ushape = OEVoxelShapeUtil.uniteBox((VoxelShape[])shapes);
        return IkisugiVoxelShape.getInstance().rotate(ushape, (IIkisugiVoxelShape)shape, angledAxis);
    }

    public static VoxelShape rotateBoxY90(VoxelShape shape) {
        return OEVoxelShapeUtil.rotateBox(shape, RotateAngledAxis.Y90);
    }

    public static VoxelShape rotateBoxY180(VoxelShape shape) {
        return OEVoxelShapeUtil.rotateBox(shape, RotateAngledAxis.Y180);
    }

    public static VoxelShape rotateBoxY270(VoxelShape shape) {
        return OEVoxelShapeUtil.rotateBox(shape, RotateAngledAxis.Y270);
    }

    public static VoxelShape rotateBoxX90(VoxelShape shape) {
        return OEVoxelShapeUtil.rotateBox(shape, RotateAngledAxis.X90);
    }

    public static VoxelShape rotateBoxX180(VoxelShape shape) {
        return OEVoxelShapeUtil.rotateBox(shape, RotateAngledAxis.X180);
    }

    public static VoxelShape rotateBoxX270(VoxelShape shape) {
        return OEVoxelShapeUtil.rotateBox(shape, RotateAngledAxis.X270);
    }

    public static VoxelShape rotateBoxZ90(VoxelShape shape) {
        return OEVoxelShapeUtil.rotateBox(shape, RotateAngledAxis.Z90);
    }

    public static VoxelShape rotateBoxZ180(VoxelShape shape) {
        return OEVoxelShapeUtil.rotateBox(shape, RotateAngledAxis.Z180);
    }

    public static VoxelShape rotateBoxDirection(VoxelShape shape, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> OEVoxelShapeUtil.rotateBoxY180(shape);
            case Direction.EAST -> OEVoxelShapeUtil.rotateBoxY270(shape);
            case Direction.WEST -> OEVoxelShapeUtil.rotateBoxY90(shape);
            default -> shape;
        };
    }

    public static VoxelShape getShapeFromResource(ResourceLocation location) {
        InputStream stream = OEVoxelShapeUtil.class.getResourceAsStream("/data/" + location.m_135827_() + "/shape/" + location.m_135815_() + ".json");
        if (stream == null) {
            return OEVoxelShapeUtil.makeBox(16.0, 16.0, 16.0, 16.0, 16.0, 16.0);
        }
        return IkisugiVoxelShape.getInstance().getShapeFromJson((JsonObject)gson.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class));
    }
}

