/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.util;

import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.otyacraftengine.util.OEURLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.chunk.LevelChunk;

public class OEPlayerUtil {
    public static final String NAME_BY_UUID_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s";
    public static final String UUID_BY_NAME_URL = "https://api.mojang.com/users/profiles/minecraft/%s";

    public static Optional<UUID> getUUIDByName(String name) {
        try {
            JsonObject jo = OEURLUtil.getJson(new URL(String.format(UUID_BY_NAME_URL, name)));
            String uuidstr = jo.get("id").getAsString();
            return Optional.of(FNStringUtil.fromNoHyphenStringToUUID(uuidstr));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Optional.empty();
        }
    }

    public static CompletableFuture<Void> getUUIDByNameAsync(String name, Consumer<Optional<UUID>> uuid) {
        try {
            return OEURLUtil.getJsonAsync(new URL(String.format(UUID_BY_NAME_URL, name)), n -> {
                String na = null;
                try {
                    na = n.get("id").getAsString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                uuid.accept(na == null ? Optional.empty() : Optional.of(FNStringUtil.fromNoHyphenStringToUUID(na)));
            });
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return CompletableFuture.completedFuture(null);
        }
    }

    public static Optional<String> getNameByUUID(UUID uuid) {
        try {
            JsonObject jo = OEURLUtil.getJson(new URL(String.format(NAME_BY_UUID_URL, uuid.toString())));
            String name = jo.get("name").getAsString();
            return Optional.ofNullable(name);
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static CompletableFuture<Void> getNameByUUIDAsync(UUID id, Consumer<Optional<String>> name) {
        try {
            return OEURLUtil.getJsonAsync(new URL(String.format(NAME_BY_UUID_URL, id.toString())), n -> {
                String na = null;
                try {
                    na = n.get("name").getAsString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                name.accept(Optional.ofNullable(na));
            });
        }
        catch (MalformedURLException malformedURLException) {
            return CompletableFuture.completedFuture(null);
        }
    }

    public static void giveItem(Player player, ItemStack stack) {
        if (!player.m_36356_(stack)) {
            player.m_7197_(stack, false, true);
        }
    }

    public static void changeOrGiveItem(Player player, InteractionHand hand, ItemStack stack) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!player.m_150110_().f_35937_) {
            heldItem.m_41774_(1);
        }
        if (heldItem.m_41619_()) {
            player.m_21008_(hand, stack);
        } else {
            OEPlayerUtil.giveItem(player, stack);
        }
    }

    public static void doPlayers(LevelChunk chunk, Consumer<ServerPlayer> playerConsumer) {
        ((ServerChunkCache)chunk.m_62953_().m_7726_()).f_8325_.m_5960_(chunk.m_7697_(), false).forEach(playerConsumer);
    }
}

