package dev.felnull.otyacraftengine.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class OEBaseContainerBlockEntity extends BaseContainerBlockEntity implements IClientSyncbleBlockEntity, IInstructionBlockEntity, ItemDroppedBlockEntity {

    protected OEBaseContainerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public CompoundTag getSyncData(ServerPlayer player, CompoundTag tag) {
        ContainerHelper.m_18973_(tag, getItems());
        return tag;
    }

    @Override
    public void onSync(CompoundTag tag) {
        getItems().clear();
        ContainerHelper.m_18980_(tag, getItems());
    }

    @Override
    public void sync() {
        IClientSyncbleBlockEntity.syncBlockEntity(this);
    }

    @Override
    public CompoundTag onInstruction(ServerPlayer player, String name, int num, CompoundTag data) {
        return null;
    }

    @Override
    public boolean canInstructionWith(ServerPlayer player, String name, int num, CompoundTag data) {
        return m_6542_(player);
    }

    @NotNull
    abstract public NonNullList<ItemStack> getItems();

    @Override
    public int m_6643_() {
        return getItems().size();
    }

    @Override
    public boolean m_7983_() {
        return getItems().stream().allMatch(ItemStack::m_41619_);
    }

    @Override
    public ItemStack m_8020_(int i) {
        return getItems().get(i);
    }

    @Override
    public ItemStack m_7407_(int i, int j) {
        return ContainerHelper.m_18969_(getItems(), i, j);
    }

    @Override
    public ItemStack m_8016_(int i) {
        return ContainerHelper.m_18966_(getItems(), i);
    }

    @Override
    public void m_6836_(int i, ItemStack stack) {
        ItemStack itemstack = getItems().get(i);
        boolean flag = !stack.m_41619_() && stack.m_41656_(itemstack) && ItemStack.m_41658_(stack, itemstack);
        getItems().set(i, stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (flag)
            this.m_6596_();
    }

    @Override
    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this)
            return false;
        return isUsableByPlayer(player);
    }

    @Override
    public void m_6211_() {
        getItems().clear();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_(tag, getItems());
    }

    @Override
    public CompoundTag m_6945_(CompoundTag tag) {
        ContainerHelper.m_18973_(tag, getItems());
        return super.m_6945_(tag);
    }

    public boolean isUsableByPlayer(Player player) {
        return m_58904_().m_7702_(m_58899_()) == this && player.m_20275_((double) m_58899_().m_123341_() + 0.5D, (double) m_58899_().m_123342_() + 0.5D, (double) m_58899_().m_123343_() + 0.5D) <= 64.0D;
    }

    @Override
    public NonNullList<ItemStack> getDroppedItems() {
        return getItems();
    }

    @Override
    public boolean isRetainEmpty() {
        return m_7983_();
    }
}
